/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.BooleanPropertyDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javax.annotation.Nonnull;

class UIThreadAwareBooleanProperty
extends BooleanPropertyDecorator
implements UIThreadAware {
    UIThreadAwareBooleanProperty(@Nonnull BooleanProperty delegate) {
        super(delegate);
    }

    @Override
    public void set(boolean value) {
        if (Platform.isFxApplicationThread()) {
            this.getDelegate().set(value);
        } else {
            Platform.runLater(() -> this.getDelegate().set(value));
        }
    }

    @Override
    public void addListener(ChangeListener<? super Boolean> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<Boolean>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super Boolean> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<Boolean>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

