/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareBooleanBinding;
import griffon.javafx.beans.binding.UIThreadAwareBooleanProperty;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareDoubleBinding;
import griffon.javafx.beans.binding.UIThreadAwareDoubleProperty;
import griffon.javafx.beans.binding.UIThreadAwareFloatBinding;
import griffon.javafx.beans.binding.UIThreadAwareFloatProperty;
import griffon.javafx.beans.binding.UIThreadAwareIntegerBinding;
import griffon.javafx.beans.binding.UIThreadAwareIntegerProperty;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import griffon.javafx.beans.binding.UIThreadAwareListChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareListProperty;
import griffon.javafx.beans.binding.UIThreadAwareLongBinding;
import griffon.javafx.beans.binding.UIThreadAwareLongProperty;
import griffon.javafx.beans.binding.UIThreadAwareMapChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareMapProperty;
import griffon.javafx.beans.binding.UIThreadAwareObjectBinding;
import griffon.javafx.beans.binding.UIThreadAwareObjectProperty;
import griffon.javafx.beans.binding.UIThreadAwareObservableBooleanValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableDoubleValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableFloatValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableIntegerValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableLongValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableObjectValue;
import griffon.javafx.beans.binding.UIThreadAwareObservableStringValue;
import griffon.javafx.beans.binding.UIThreadAwarePropertyBoolean;
import griffon.javafx.beans.binding.UIThreadAwarePropertyDouble;
import griffon.javafx.beans.binding.UIThreadAwarePropertyFloat;
import griffon.javafx.beans.binding.UIThreadAwarePropertyInteger;
import griffon.javafx.beans.binding.UIThreadAwarePropertyLong;
import griffon.javafx.beans.binding.UIThreadAwarePropertyString;
import griffon.javafx.beans.binding.UIThreadAwareSetChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareSetProperty;
import griffon.javafx.beans.binding.UIThreadAwareStringBinding;
import griffon.javafx.beans.binding.UIThreadAwareStringProperty;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javax.annotation.Nonnull;

public final class UIThreadAwareBindings {
    private static final String ERROR_LISTENER_NULL = "Argument 'listener' must not be null";
    private static final String ERROR_CONSUMER_NULL = "Argument 'consumer' must not be null";
    private static final String ERROR_RUNNABLE_NULL = "Argument 'runnable' must not be null";
    private static final String ERROR_OBSERVABLE_NULL = "Argument 'observable' must not be null";
    private static final String ERROR_PROPERTY_NULL = "Argument 'property' must not be null";
    private static final String ERROR_BINDING_NULL = "Argument 'binding' must not be null";

    private UIThreadAwareBindings() {
    }

    public static <T> ChangeListener<T> uiThreadAwareBind(@Nonnull Property<T> property, @Nonnull ObservableValue<T> observable) {
        Objects.requireNonNull(property, ERROR_PROPERTY_NULL);
        property.setValue(observable.getValue());
        return UIThreadAwareBindings.uiThreadAwareChangeListener(observable, (v, o, n) -> property.setValue(n));
    }

    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull ObservableValue<T> observable, @Nonnull ChangeListener<T> listener) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ChangeListener<T> uiListener = UIThreadAwareBindings.uiThreadAwareChangeListener(listener);
        observable.addListener(uiListener);
        return uiListener;
    }

    @Nonnull
    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull ChangeListener<T> listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        return listener instanceof UIThreadAware ? listener : new UIThreadAwareChangeListener(listener);
    }

    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull ObservableValue<T> observable, @Nonnull Consumer<T> consumer) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ChangeListener<T> listener = UIThreadAwareBindings.uiThreadAwareChangeListener(consumer);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull Consumer<T> consumer) {
        Objects.requireNonNull(consumer, ERROR_CONSUMER_NULL);
        return new UIThreadAwareChangeListener((observable, oldValue, newValue) -> consumer.accept(newValue));
    }

    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull ObservableValue<T> observable, @Nonnull Runnable runnable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ChangeListener<T> listener = UIThreadAwareBindings.uiThreadAwareChangeListener(runnable);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <T> ChangeListener<T> uiThreadAwareChangeListener(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        return new UIThreadAwareChangeListener((observable, oldValue, newValue) -> runnable.run());
    }

    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull Observable observable, @Nonnull InvalidationListener listener) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        InvalidationListener uiListener = UIThreadAwareBindings.uiThreadAwareInvalidationListener(listener);
        observable.addListener(uiListener);
        return uiListener;
    }

    @Nonnull
    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull InvalidationListener listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        return listener instanceof UIThreadAware ? listener : new UIThreadAwareInvalidationListener(listener);
    }

    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull Observable observable, @Nonnull Consumer<Observable> consumer) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        InvalidationListener listener = UIThreadAwareBindings.uiThreadAwareInvalidationListener(consumer);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull Consumer<Observable> consumer) {
        Objects.requireNonNull(consumer, ERROR_CONSUMER_NULL);
        return new UIThreadAwareInvalidationListener(consumer::accept);
    }

    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull Observable observable, @Nonnull Runnable runnable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        InvalidationListener listener = UIThreadAwareBindings.uiThreadAwareInvalidationListener(runnable);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static InvalidationListener uiThreadAwareInvalidationListener(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        return new UIThreadAwareInvalidationListener(observable -> runnable.run());
    }

    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull ObservableList<E> observable, @Nonnull ListChangeListener<E> listener) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ListChangeListener<E> uiListener = UIThreadAwareBindings.uiThreadAwareListChangeListener(listener);
        observable.addListener(uiListener);
        return listener;
    }

    @Nonnull
    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull ListChangeListener<E> listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        return listener instanceof UIThreadAware ? listener : new UIThreadAwareListChangeListener(listener);
    }

    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull ObservableList<E> observable, @Nonnull Consumer<ListChangeListener.Change<? extends E>> consumer) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ListChangeListener<? extends E> listener = UIThreadAwareBindings.uiThreadAwareListChangeListener(consumer);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull Consumer<ListChangeListener.Change<? extends E>> consumer) {
        Objects.requireNonNull(consumer, ERROR_CONSUMER_NULL);
        return new UIThreadAwareListChangeListener(consumer::accept);
    }

    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull ObservableList<E> observable, @Nonnull Runnable runnable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        ListChangeListener<E> listener = UIThreadAwareBindings.uiThreadAwareListChangeListener(runnable);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <E> ListChangeListener<E> uiThreadAwareListChangeListener(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        return new UIThreadAwareListChangeListener(change -> runnable.run());
    }

    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull ObservableMap<K, V> observable, @Nonnull MapChangeListener<K, V> listener) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        MapChangeListener<K, V> uiListener = UIThreadAwareBindings.uiThreadAwareMapChangeListener(listener);
        observable.addListener(uiListener);
        return listener;
    }

    @Nonnull
    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull MapChangeListener<K, V> listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        return listener instanceof UIThreadAware ? listener : new UIThreadAwareMapChangeListener(listener);
    }

    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull ObservableMap<K, V> observable, @Nonnull Consumer<MapChangeListener.Change<? extends K, ? extends V>> consumer) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        MapChangeListener<? extends K, ? extends V> listener = UIThreadAwareBindings.uiThreadAwareMapChangeListener(consumer);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull Consumer<MapChangeListener.Change<? extends K, ? extends V>> consumer) {
        Objects.requireNonNull(consumer, ERROR_CONSUMER_NULL);
        return new UIThreadAwareMapChangeListener(consumer::accept);
    }

    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull ObservableMap<K, V> observable, @Nonnull Runnable runnable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        MapChangeListener<K, V> listener = UIThreadAwareBindings.uiThreadAwareMapChangeListener(runnable);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <K, V> MapChangeListener<K, V> uiThreadAwareMapChangeListener(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        return new UIThreadAwareMapChangeListener(change -> runnable.run());
    }

    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull ObservableSet<E> observable, @Nonnull SetChangeListener<E> listener) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        SetChangeListener<E> uiListener = UIThreadAwareBindings.uiThreadAwareSetChangeListener(listener);
        observable.addListener(uiListener);
        return listener;
    }

    @Nonnull
    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull SetChangeListener<E> listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        return listener instanceof UIThreadAware ? listener : new UIThreadAwareSetChangeListener(listener);
    }

    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull ObservableSet<E> observable, @Nonnull Consumer<SetChangeListener.Change<? extends E>> consumer) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        SetChangeListener<? extends E> listener = UIThreadAwareBindings.uiThreadAwareSetChangeListener(consumer);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull Consumer<SetChangeListener.Change<? extends E>> consumer) {
        Objects.requireNonNull(consumer, ERROR_CONSUMER_NULL);
        return new UIThreadAwareSetChangeListener(consumer::accept);
    }

    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull ObservableSet<E> observable, @Nonnull Runnable runnable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        SetChangeListener<E> listener = UIThreadAwareBindings.uiThreadAwareSetChangeListener(runnable);
        observable.addListener(listener);
        return listener;
    }

    @Nonnull
    public static <E> SetChangeListener<E> uiThreadAwareSetChangeListener(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        return new UIThreadAwareSetChangeListener(change -> runnable.run());
    }

    @Nonnull
    public static BooleanProperty uiThreadAwareBooleanProperty(@Nonnull BooleanProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareBooleanProperty(observable);
    }

    @Nonnull
    public static IntegerProperty uiThreadAwareIntegerProperty(@Nonnull IntegerProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareIntegerProperty(observable);
    }

    @Nonnull
    public static LongProperty uiThreadAwareLongProperty(@Nonnull LongProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareLongProperty(observable);
    }

    @Nonnull
    public static FloatProperty uiThreadAwareFloatProperty(@Nonnull FloatProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareFloatProperty(observable);
    }

    @Nonnull
    public static DoubleProperty uiThreadAwareDoubleProperty(@Nonnull DoubleProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareDoubleProperty(observable);
    }

    @Nonnull
    public static StringProperty uiThreadAwareStringProperty(@Nonnull StringProperty observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareStringProperty(observable);
    }

    @Nonnull
    public static Property<Boolean> uiThreadAwarePropertyBoolean(@Nonnull Property<Boolean> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyBoolean(observable);
    }

    @Nonnull
    public static Property<Integer> uiThreadAwarePropertyInteger(@Nonnull Property<Integer> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyInteger(observable);
    }

    @Nonnull
    public static Property<Long> uiThreadAwarePropertyLong(@Nonnull Property<Long> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyLong(observable);
    }

    @Nonnull
    public static Property<Float> uiThreadAwarePropertyFloat(@Nonnull Property<Float> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyFloat(observable);
    }

    @Nonnull
    public static Property<Double> uiThreadAwarePropertyDouble(@Nonnull Property<Double> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyDouble(observable);
    }

    @Nonnull
    public static Property<String> uiThreadAwarePropertyString(@Nonnull Property<String> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwarePropertyString(observable);
    }

    @Nonnull
    public static <T> ObjectProperty<T> uiThreadAwareObjectProperty(@Nonnull ObjectProperty<T> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObjectProperty(observable);
    }

    @Nonnull
    public static <E> ListProperty<E> uiThreadAwareListProperty(@Nonnull ListProperty<E> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareListProperty(observable);
    }

    @Nonnull
    public static <E> SetProperty<E> uiThreadAwareSetProperty(@Nonnull SetProperty<E> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareSetProperty(observable);
    }

    @Nonnull
    public static <K, V> MapProperty<K, V> uiThreadAwareMapProperty(@Nonnull MapProperty<K, V> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareMapProperty(observable);
    }

    @Nonnull
    public static <T> ObservableValue<T> uiThreadAwareObservable(@Nonnull ObservableValue<T> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableObjectValue(observable);
    }

    @Nonnull
    public static ObservableStringValue uiThreadAwareObservableString(@Nonnull ObservableStringValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableStringValue(observable);
    }

    @Nonnull
    public static ObservableBooleanValue uiThreadAwareObservableBoolean(@Nonnull ObservableBooleanValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableBooleanValue(observable);
    }

    @Nonnull
    public static ObservableIntegerValue uiThreadAwareObservableInteger(@Nonnull ObservableIntegerValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableIntegerValue(observable);
    }

    @Nonnull
    public static ObservableLongValue uiThreadAwareObservableLong(@Nonnull ObservableLongValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableLongValue(observable);
    }

    @Nonnull
    public static ObservableFloatValue uiThreadAwareObservableFloat(@Nonnull ObservableFloatValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableFloatValue(observable);
    }

    @Nonnull
    public static ObservableDoubleValue uiThreadAwareObservableDouble(@Nonnull ObservableDoubleValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return observable instanceof UIThreadAware ? observable : new UIThreadAwareObservableDoubleValue(observable);
    }

    @Nonnull
    public static BooleanBinding uiThreadAwareBooleanBinding(@Nonnull BooleanBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareBooleanBinding(binding);
    }

    @Nonnull
    public static IntegerBinding uiThreadAwareIntegerBinding(@Nonnull IntegerBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareIntegerBinding(binding);
    }

    @Nonnull
    public static LongBinding uiThreadAwareLongBinding(@Nonnull LongBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareLongBinding(binding);
    }

    @Nonnull
    public static FloatBinding uiThreadAwareFloatBinding(@Nonnull FloatBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareFloatBinding(binding);
    }

    @Nonnull
    public static DoubleBinding uiThreadAwareDoubleBinding(@Nonnull DoubleBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareDoubleBinding(binding);
    }

    @Nonnull
    public static StringBinding uiThreadAwareStringBinding(@Nonnull StringBinding binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareStringBinding(binding);
    }

    @Nonnull
    public static <T> ObjectBinding<T> uiThreadAwareObjectBinding(@Nonnull ObjectBinding<T> binding) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        return binding instanceof UIThreadAware ? binding : new UIThreadAwareObjectBinding(binding);
    }
}

