/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javax.annotation.Nonnull;

public class SetPropertyDecorator<E>
extends SetProperty<E> {
    private final SetProperty<E> delegate;

    public SetPropertyDecorator(@Nonnull SetProperty<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final SetProperty<E> getDelegate() {
        return this.delegate;
    }

    public void setValue(ObservableSet<E> v) {
        this.delegate.setValue(v);
    }

    public void bindBidirectional(Property<ObservableSet<E>> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<ObservableSet<E>> other) {
        this.delegate.unbindBidirectional(other);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.delegate.toString();
    }

    public void bindContentBidirectional(ObservableSet<E> set) {
        this.delegate.bindContentBidirectional(set);
    }

    public void unbindContentBidirectional(Object object) {
        this.delegate.unbindContentBidirectional(object);
    }

    public void bindContent(ObservableSet<E> set) {
        this.delegate.bindContent(set);
    }

    public void unbindContent(Object object) {
        this.delegate.unbindContent(object);
    }

    public ObservableSet<E> getValue() {
        return this.delegate.getValue();
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public ReadOnlyIntegerProperty sizeProperty() {
        return this.delegate.sizeProperty();
    }

    public ReadOnlyBooleanProperty emptyProperty() {
        return this.delegate.emptyProperty();
    }

    public BooleanBinding isEqualTo(ObservableSet<?> other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableSet<?> other) {
        return this.delegate.isNotEqualTo(other);
    }

    public BooleanBinding isNull() {
        return this.delegate.isNull();
    }

    public BooleanBinding isNotNull() {
        return this.delegate.isNotNull();
    }

    public StringBinding asString() {
        return this.delegate.asString();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object obj) {
        return this.delegate.contains(obj);
    }

    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] array) {
        return this.delegate.toArray((Object[])array);
    }

    public boolean add(E element) {
        return this.delegate.add(element);
    }

    public boolean remove(Object obj) {
        return this.delegate.remove(obj);
    }

    public boolean containsAll(Collection<?> objects) {
        return this.delegate.containsAll(objects);
    }

    public boolean addAll(Collection<? extends E> elements) {
        return this.delegate.addAll(elements);
    }

    public boolean removeAll(Collection<?> objects) {
        return this.delegate.removeAll(objects);
    }

    public boolean retainAll(Collection<?> objects) {
        return this.delegate.retainAll(objects);
    }

    public void clear() {
        this.delegate.clear();
    }

    public ObservableSet<E> get() {
        return (ObservableSet)this.delegate.get();
    }

    public void addListener(ChangeListener<? super ObservableSet<E>> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super ObservableSet<E>> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(SetChangeListener<? super E> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(SetChangeListener<? super E> listener) {
        this.delegate.removeListener(listener);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void bind(ObservableValue<? extends ObservableSet<E>> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void set(ObservableSet<E> value) {
        this.delegate.set(value);
    }
}

