/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReducingBindings {
    private static final String ERROR_ITEMS_NULL = "Argument 'items' must not be null";
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    private static final String ERROR_REDUCER_NULL = "Argument 'reducer' must not be null";
    private static final String ERROR_SUPPLIER_NULL = "Argument 'supplier' must not be null";

    private ReducingBindings() {
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> reduce(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> reduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> reduce(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.values().stream().reduce(operator).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> reduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.values().stream().reduce(operator).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <K, V> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Integer>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Integer>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> LongBinding reduceThenMapToLong(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding reduceThenMapToLong(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding reduceThenMapToLong(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Long>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> LongBinding reduceThenMapToLong(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Long>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> FloatBinding reduceThenMapToFloat(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding reduceThenMapToFloat(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding reduceThenMapToFloat(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Float>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> FloatBinding reduceThenMapToFloat(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Float>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Double>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, Double>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> StringBinding reduceThenMapToString(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding reduceThenMapToString(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createStringBinding(() -> (String)mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding reduceThenMapToString(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, String>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> StringBinding reduceThenMapToString(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, String>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.stream().reduce(operator).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.stream().reduce(operator).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Function<Object, String> mapperValue = mapper != null ? mapper : String::valueOf;
        return Bindings.createStringBinding(() -> (String)mapperValue.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Function<Object, String> mapperValue = mapper != null ? mapper : String::valueOf;
        return Bindings.createStringBinding(() -> (String)mapperValue.apply(items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return (String)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return (String)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, ? extends Number> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue))).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Number> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier))).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, ? extends Number>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue))).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Number>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier))).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.stream().reduce(operator).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <T> ObjectBinding<T> reduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            return items.stream().reduce(operator).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Function<Object, String> mapperValue = mapper != null ? mapper : String::valueOf;
        return Bindings.createStringBinding(() -> (String)mapperValue.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Function<Object, String> mapperValue = mapper != null ? mapper : String::valueOf;
        return Bindings.createStringBinding(() -> (String)mapperValue.apply(items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return (String)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding reduceThenMapToString(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return (String)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding reduceThenMapToInteger(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding reduceThenMapToLong(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding reduceThenMapToFloat(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding reduceThenMapToDouble(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding reduceThenMapToBoolean(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, ? extends Number> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)mapper.apply(items.stream().reduce(reducer).orElse(defaultValue))).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, Number> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier))).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, ? extends Number>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue))).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding reduceThenMapToNumber(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, Number>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier))).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableList<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply(items.stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> reducer, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply((Object)items.stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableSet<T> items, @Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> reducer, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply((Object)items.values().stream().reduce(reducer).orElse(defaultValue)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull BinaryOperator<V> reducer, @Nonnull Function<? super V, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply((Object)items.values().stream().reduce(reducer).orElseGet(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableMap<K, V> items, @Nullable V defaultValue, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, R>> mapper) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.values().stream().reduce(operator).orElse(defaultValue));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> reduceThenMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<BinaryOperator<V>> reducer, @Nonnull ObservableValue<Function<? super V, R>> mapper) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator operator = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(operator, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(items.values().stream().reduce(operator).orElseGet(supplier));
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableList<T> items, @Nullable R defaultValue, @Nonnull Function<? super T, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super T, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableList<T> items, @Nullable R defaultValue, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableSet<T> items, @Nullable R defaultValue, @Nonnull Function<? super T, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super T, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableSet<T> items, @Nullable R defaultValue, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable R defaultValue, @Nonnull Function<? super V, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super V, R> mapper, @Nonnull BinaryOperator<R> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable R defaultValue, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<BinaryOperator<R>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableList<T> items, @Nullable Boolean defaultValue, @Nonnull Function<? super T, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super T, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableList<T> items, @Nullable Boolean defaultValue, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableSet<T> items, @Nullable Boolean defaultValue, @Nonnull Function<? super T, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super T, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableSet<T> items, @Nullable Boolean defaultValue, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Boolean defaultValue, @Nonnull Function<? super V, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super V, Boolean> mapper, @Nonnull BinaryOperator<Boolean> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Boolean defaultValue, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper, @Nonnull ObservableValue<BinaryOperator<Boolean>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableList<T> items, @Nullable Integer defaultValue, @Nonnull Function<? super T, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super T, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableList<T> items, @Nullable Integer defaultValue, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableSet<T> items, @Nullable Integer defaultValue, @Nonnull Function<? super T, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super T, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableSet<T> items, @Nullable Integer defaultValue, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Integer defaultValue, @Nonnull Function<? super V, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super V, Integer> mapper, @Nonnull BinaryOperator<Integer> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Integer defaultValue, @Nonnull ObservableValue<Function<? super V, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super V, Integer>> mapper, @Nonnull ObservableValue<BinaryOperator<Integer>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableList<T> items, @Nullable Long defaultValue, @Nonnull Function<? super T, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super T, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableList<T> items, @Nullable Long defaultValue, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableSet<T> items, @Nullable Long defaultValue, @Nonnull Function<? super T, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createLongBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super T, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableSet<T> items, @Nullable Long defaultValue, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Long defaultValue, @Nonnull Function<? super V, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super V, Long> mapper, @Nonnull BinaryOperator<Long> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Long defaultValue, @Nonnull ObservableValue<Function<? super V, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super V, Long>> mapper, @Nonnull ObservableValue<BinaryOperator<Long>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableList<T> items, @Nullable Float defaultValue, @Nonnull Function<? super T, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super T, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableList<T> items, @Nullable Float defaultValue, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableSet<T> items, @Nullable Float defaultValue, @Nonnull Function<? super T, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super T, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableSet<T> items, @Nullable Float defaultValue, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Float defaultValue, @Nonnull Function<? super V, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super V, Float> mapper, @Nonnull BinaryOperator<Float> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Float defaultValue, @Nonnull ObservableValue<Function<? super V, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super V, Float>> mapper, @Nonnull ObservableValue<BinaryOperator<Float>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableList<T> items, @Nullable Double defaultValue, @Nonnull Function<? super T, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super T, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableList<T> items, @Nullable Double defaultValue, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableSet<T> items, @Nullable Double defaultValue, @Nonnull Function<? super T, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super T, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableSet<T> items, @Nullable Double defaultValue, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Double defaultValue, @Nonnull Function<? super V, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super V, Double> mapper, @Nonnull BinaryOperator<Double> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Double defaultValue, @Nonnull ObservableValue<Function<? super V, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super V, Double>> mapper, @Nonnull ObservableValue<BinaryOperator<Double>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableList<T> items, @Nullable Number defaultValue, @Nonnull Function<? super T, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Number> supplier, @Nonnull Function<? super T, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)items.stream().map(mapper).reduce(reducer).orElseGet(supplier)).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableList<T> items, @Nullable Number defaultValue, @Nonnull ObservableValue<Function<? super T, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<Number> supplier, @Nonnull ObservableValue<Function<? super T, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier)).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableSet<T> items, @Nullable Number defaultValue, @Nonnull Function<? super T, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Number> supplier, @Nonnull Function<? super T, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)items.stream().map(mapper).reduce(reducer).orElseGet(supplier)).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableSet<T> items, @Nullable Number defaultValue, @Nonnull ObservableValue<Function<? super T, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> NumberBinding mapToNumberThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Number> supplier, @Nonnull ObservableValue<Function<? super T, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier)).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding mapToNumberThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Number defaultValue, @Nonnull Function<? super V, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding mapToNumberThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Number> supplier, @Nonnull Function<? super V, Number> mapper, @Nonnull BinaryOperator<Number> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> ((Number)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier)).doubleValue(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding mapToNumberThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable Number defaultValue, @Nonnull ObservableValue<Function<? super V, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding mapToNumberThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Number> supplier, @Nonnull ObservableValue<Function<? super V, Number>> mapper, @Nonnull ObservableValue<BinaryOperator<Number>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return ((Number)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier)).doubleValue();
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableList<T> items, @Nullable String defaultValue, @Nonnull Function<? super T, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super T, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableList<T> items, @Nullable String defaultValue, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableSet<T> items, @Nullable String defaultValue, @Nonnull Function<? super T, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        return Bindings.createStringBinding(() -> items.stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super T, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableSet<T> items, @Nullable String defaultValue, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenReduce(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)items.stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable String defaultValue, @Nonnull Function<? super V, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> items.values().stream().map(mapper).reduce(reducer).orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super V, String> mapper, @Nonnull BinaryOperator<String> reducer) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.values().stream().map(mapper).reduce(reducer).orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenReduce(@Nonnull ObservableMap<K, V> items, @Nullable String defaultValue, @Nonnull ObservableValue<Function<? super V, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().map(mapperValue).reduce(reducerValue).orElse(defaultValue);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenReduce(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super V, String>> mapper, @Nonnull ObservableValue<BinaryOperator<String>> reducer) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(reducer, ERROR_REDUCER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            BinaryOperator reducerValue = (BinaryOperator)reducer.getValue();
            Objects.requireNonNull(reducerValue, ERROR_REDUCER_NULL);
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)items.values().stream().map(mapperValue).reduce(reducerValue).orElseGet(supplier);
        }, (Observable[])new Observable[]{items, reducer, mapper});
    }
}

