/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class PropertyDecorator<T>
implements Property<T> {
    private final Property<T> delegate;

    public PropertyDecorator(@Nonnull Property<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final Property<T> getDelegate() {
        return this.delegate;
    }

    public void bind(ObservableValue<? extends T> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void bindBidirectional(Property<T> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<T> other) {
        this.delegate.unbindBidirectional(other);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void addListener(ChangeListener<? super T> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super T> listener) {
        this.delegate.removeListener(listener);
    }

    public T getValue() {
        return (T)this.delegate.getValue();
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public void setValue(T value) {
        this.delegate.setValue(value);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.delegate.toString();
    }
}

