/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class ObservableValueDecorator<T>
implements ObservableValue<T> {
    private final ObservableValue<T> delegate;

    public ObservableValueDecorator(@Nonnull ObservableValue<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final ObservableValue<T> getDelegate() {
        return this.delegate;
    }

    public void addListener(ChangeListener<? super T> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super T> listener) {
        this.delegate.removeListener(listener);
    }

    public T getValue() {
        return (T)this.delegate.getValue();
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.delegate.toString();
    }
}

