/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class ObjectPropertyDecorator<T>
extends ObjectProperty<T> {
    private final ObjectProperty<T> delegate;

    public ObjectPropertyDecorator(@Nonnull ObjectProperty<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final ObjectProperty<T> getDelegate() {
        return this.delegate;
    }

    public void setValue(T v) {
        this.delegate.setValue(v);
    }

    public void bindBidirectional(Property<T> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<T> other) {
        this.delegate.unbindBidirectional(other);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.delegate.toString();
    }

    public T getValue() {
        return (T)this.delegate.getValue();
    }

    public BooleanBinding isEqualTo(ObservableObjectValue<?> other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isEqualTo(Object other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableObjectValue<?> other) {
        return this.delegate.isNotEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(Object other) {
        return this.delegate.isNotEqualTo(other);
    }

    public BooleanBinding isNull() {
        return this.delegate.isNull();
    }

    public BooleanBinding isNotNull() {
        return this.delegate.isNotNull();
    }

    public StringBinding asString() {
        return this.delegate.asString();
    }

    public StringBinding asString(String format) {
        return this.delegate.asString(format);
    }

    public StringBinding asString(Locale locale, String format) {
        return this.delegate.asString(locale, format);
    }

    public T get() {
        return (T)this.delegate.get();
    }

    public void addListener(ChangeListener<? super T> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super T> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void bind(ObservableValue<? extends T> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void set(T value) {
        this.delegate.set(value);
    }
}

