/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;

public class ObjectBindingDecorator<T>
extends ObjectBinding<T> {
    private final ObjectBinding<T> delegate;

    public ObjectBindingDecorator(@Nonnull ObjectBinding<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final ObjectBinding<T> getDelegate() {
        return this.delegate;
    }

    protected T computeValue() {
        return (T)this.delegate.get();
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public T getValue() {
        return (T)this.getDelegate().getValue();
    }

    public BooleanBinding isEqualTo(ObservableObjectValue other) {
        return this.getDelegate().isEqualTo(other);
    }

    public BooleanBinding isEqualTo(Object other) {
        return this.getDelegate().isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableObjectValue other) {
        return this.getDelegate().isNotEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(Object other) {
        return this.getDelegate().isNotEqualTo(other);
    }

    public BooleanBinding isNull() {
        return this.getDelegate().isNull();
    }

    public BooleanBinding isNotNull() {
        return this.getDelegate().isNotNull();
    }

    public StringBinding asString() {
        return this.getDelegate().asString();
    }

    public StringBinding asString(String format) {
        return this.getDelegate().asString(format);
    }

    public StringBinding asString(Locale locale, String format) {
        return this.getDelegate().asString(locale, format);
    }

    public void addListener(InvalidationListener listener) {
        this.getDelegate().addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.getDelegate().removeListener(listener);
    }

    public void addListener(ChangeListener<? super T> listener) {
        this.getDelegate().addListener(listener);
    }

    public void removeListener(ChangeListener<? super T> listener) {
        this.getDelegate().removeListener(listener);
    }

    public void dispose() {
        this.getDelegate().dispose();
    }

    public ObservableList<?> getDependencies() {
        return this.getDelegate().getDependencies();
    }
}

