/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;

public final class MatchingBindings {
    private static final String ERROR_ITEMS_NULL = "Argument 'items' must not be null";
    private static final String ERROR_PREDICATE_NULL = "Argument 'predicate' must not be null";
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";

    private MatchingBindings() {
    }

    @Nonnull
    public static <T> BooleanBinding anyMatch(@Nonnull ObservableList<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding anyMatch(@Nonnull ObservableList<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding anyMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding anyMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding noneMatch(@Nonnull ObservableList<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding noneMatch(@Nonnull ObservableList<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding noneMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding noneMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding allMatch(@Nonnull ObservableList<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding allMatch(@Nonnull ObservableList<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding allMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding allMatch(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding anyMatch(@Nonnull ObservableSet<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding anyMatch(@Nonnull ObservableSet<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding anyMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding anyMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding noneMatch(@Nonnull ObservableSet<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding noneMatch(@Nonnull ObservableSet<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding noneMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding noneMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <T> BooleanBinding allMatch(@Nonnull ObservableSet<T> items, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> BooleanBinding allMatch(@Nonnull ObservableSet<T> items, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding allMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <T, R> BooleanBinding allMatch(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.stream().map(mapperValue).allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding anyMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Predicate<? super V> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding anyMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Function<? super V, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().map(mapper).anyMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding anyMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Predicate<? super V>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding anyMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().map(mapperValue).anyMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding noneMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Predicate<? super V> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding noneMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Function<? super V, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().map(mapper).noneMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding noneMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Predicate<? super V>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding noneMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().map(mapperValue).noneMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }

    @Nonnull
    public static <K, V> BooleanBinding allMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Predicate<? super V> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding allMatch(@Nonnull ObservableMap<K, V> items, @Nonnull Function<? super V, R> mapper, @Nonnull Predicate<? super R> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().map(mapper).allMatch(predicate), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding allMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Predicate<? super V>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate});
    }

    @Nonnull
    public static <K, V, R> BooleanBinding allMatch(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> predicate) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate predicateValue = (Predicate)predicate.getValue();
            Objects.requireNonNull(predicateValue, ERROR_PREDICATE_NULL);
            return items.values().stream().map(mapperValue).allMatch(predicateValue);
        }, (Observable[])new Observable[]{items, predicate, mapper});
    }
}

