/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.collections.MappingObservableList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MappingBindings {
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    private static final String ERROR_SUPPLIER_NULL = "Argument 'supplier' must not be null";
    private static final String ERROR_OBSERVABLE_NULL = "Argument 'observable' must not be null";
    private static final String ERROR_OBSERVABLE1_NULL = "Argument 'observable1' must not be null";
    private static final String ERROR_OBSERVABLE2_NULL = "Argument 'observable2' must not be null";
    private static final String ERROR_DEFAULT_VALUE_NULL = "Argument 'defaultValue' must not be null";

    private MappingBindings() {
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapAsObject(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, R> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapAsObject(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, R>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> BooleanBinding mapAsBoolean(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, Boolean> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> BooleanBinding mapAsBoolean(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, Boolean>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Boolean)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> IntegerBinding mapAsInteger(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, Integer> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> IntegerBinding mapAsInteger(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, Integer>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Integer)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> LongBinding mapAsLong(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, Long> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> LongBinding mapAsLong(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, Long>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Long)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> FloatBinding mapAsFloat(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, Float> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> FloatBinding mapAsFloat(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, Float>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Float)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> DoubleBinding mapAsDouble(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, Double> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> DoubleBinding mapAsDouble(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, Double>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (Double)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> StringBinding mapAsString(@Nonnull ObservableValue<T> observable, @Nonnull Function<T, String> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)mapper.apply(observable.getValue()), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T> StringBinding mapAsString(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<T, String>> mapper) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return (String)mapperValue.apply(observable.getValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<String> mapToObject(@Nonnull ObservableStringValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableStringValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<Boolean> mapToObject(@Nonnull ObservableBooleanValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableBooleanValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<Integer> mapToObject(@Nonnull ObservableIntegerValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableIntegerValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<Long> mapToObject(@Nonnull ObservableLongValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableLongValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<Float> mapToObject(@Nonnull ObservableFloatValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableFloatValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static ObjectBinding<Double> mapToObject(@Nonnull ObservableDoubleValue observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createObjectBinding(() -> ((ObservableDoubleValue)observable).get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static BooleanBinding mapToBoolean(@Nonnull ObservableObjectValue<Boolean> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createBooleanBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static IntegerBinding mapToInteger(@Nonnull ObservableObjectValue<Integer> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createIntegerBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static LongBinding mapToLong(@Nonnull ObservableObjectValue<Long> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createLongBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static FloatBinding mapToFloat(@Nonnull ObservableObjectValue<Float> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createFloatBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static DoubleBinding mapToDouble(@Nonnull ObservableObjectValue<Double> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createDoubleBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static StringBinding mapToString(@Nonnull ObservableObjectValue<String> observable) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        return Bindings.createStringBinding(() -> observable.get(), (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <S, T> ObservableList<T> mapList(@Nonnull ObservableList<? super S> source, @Nonnull Function<S, T> mapper) {
        return new MappingObservableList<T, S>(source, mapper);
    }

    @Nonnull
    public static <S, T> ObservableList<T> mapList(@Nonnull ObservableList<S> source, @Nonnull ObservableValue<Function<S, T>> mapper) {
        return new MappingObservableList<T, S>(source, mapper);
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull Function<? super T, ? extends R> mapper) {
        return MappingBindings.mapObject(observable, mapper, null);
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull Function<? super T, ? extends R> mapper, @Nullable R defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object sourceValue = observable.getValue();
            return sourceValue == null ? defaultValue : mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull Function<? super T, ? extends R> mapper, @Nonnull Supplier<R> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object sourceValue = observable.getValue();
            return sourceValue == null ? supplier.get() : mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<? super T, ? extends R>> mapper) {
        return MappingBindings.mapObject(observable, mapper, null);
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<? super T, ? extends R>> mapper, @Nullable R defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object sourceValue = observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapObject(@Nonnull ObservableValue<T> observable, @Nonnull ObservableValue<Function<? super T, ? extends R>> mapper, @Nonnull Supplier<R> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object sourceValue = observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? supplier.get() : mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull Function<Boolean, Boolean> mapper) {
        return MappingBindings.mapBoolean(observable, mapper, (Boolean)false);
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull Function<Boolean, Boolean> mapper, @Nonnull Boolean defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean sourceValue = (Boolean)observable.getValue();
            return sourceValue == null ? defaultValue : (Boolean)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull Function<Boolean, Boolean> mapper, @Nonnull Supplier<Boolean> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean sourceValue = (Boolean)observable.getValue();
            return sourceValue == null ? (Boolean)supplier.get() : (Boolean)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull ObservableValue<Function<Boolean, Boolean>> mapper) {
        return MappingBindings.mapBoolean(observable, mapper, (Boolean)false);
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull ObservableValue<Function<Boolean, Boolean>> mapper, @Nonnull Boolean defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean sourceValue = (Boolean)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (Boolean)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static BooleanBinding mapBoolean(@Nonnull ObservableValue<Boolean> observable, @Nonnull ObservableValue<Function<Boolean, Boolean>> mapper, @Nonnull Supplier<Boolean> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean sourceValue = (Boolean)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (Boolean)supplier.get() : (Boolean)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull Function<Integer, Integer> mapper) {
        return MappingBindings.mapInteger(observable, mapper, (Integer)0);
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull Function<Integer, Integer> mapper, @Nonnull Integer defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Integer sourceValue = (Integer)observable.getValue();
            return sourceValue == null ? defaultValue : (Integer)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull Function<Integer, Integer> mapper, @Nonnull Supplier<Integer> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Integer sourceValue = (Integer)observable.getValue();
            return sourceValue == null ? (Integer)supplier.get() : (Integer)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull ObservableValue<Function<Integer, Integer>> mapper) {
        return MappingBindings.mapInteger(observable, mapper, (Integer)0);
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull ObservableValue<Function<Integer, Integer>> mapper, @Nonnull Integer defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Integer sourceValue = (Integer)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (Integer)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<Integer> observable, @Nonnull ObservableValue<Function<Integer, Integer>> mapper, @Nonnull Supplier<Integer> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Integer sourceValue = (Integer)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (Integer)supplier.get() : (Integer)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull Function<Long, Long> mapper) {
        return MappingBindings.mapLong(observable, mapper, (Long)0L);
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull Function<Long, Long> mapper, @Nonnull Long defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Long sourceValue = (Long)observable.getValue();
            return sourceValue == null ? defaultValue : (Long)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull Function<Long, Long> mapper, @Nonnull Supplier<Long> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> {
            Long sourceValue = (Long)observable.getValue();
            return sourceValue == null ? (Long)supplier.get() : (Long)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull ObservableValue<Function<Long, Long>> mapper) {
        return MappingBindings.mapLong(observable, mapper, (Long)0L);
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull ObservableValue<Function<Long, Long>> mapper, @Nonnull Long defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Long sourceValue = (Long)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (Long)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<Long> observable, @Nonnull ObservableValue<Function<Long, Long>> mapper, @Nonnull Supplier<Long> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createLongBinding(() -> {
            Long sourceValue = (Long)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (Long)supplier.get() : (Long)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull Function<Float, Float> mapper) {
        return MappingBindings.mapFloat(observable, mapper, Float.valueOf(0.0f));
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull Function<Float, Float> mapper, @Nonnull Float defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Float sourceValue = (Float)observable.getValue();
            return sourceValue == null ? defaultValue : (Float)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull Function<Float, Float> mapper, @Nonnull Supplier<Float> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> {
            Float sourceValue = (Float)observable.getValue();
            return sourceValue == null ? (Float)supplier.get() : (Float)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull ObservableValue<Function<Float, Float>> mapper) {
        return MappingBindings.mapFloat(observable, mapper, Float.valueOf(0.0f));
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull ObservableValue<Function<Float, Float>> mapper, @Nullable Float defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Float sourceValue = (Float)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (Float)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<Float> observable, @Nonnull ObservableValue<Function<Float, Float>> mapper, @Nonnull Supplier<Float> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createFloatBinding(() -> {
            Float sourceValue = (Float)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (Float)supplier.get() : (Float)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull Function<Double, Double> mapper) {
        return MappingBindings.mapDouble(observable, mapper, (Double)0.0);
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull Function<Double, Double> mapper, @Nullable Double defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Double sourceValue = (Double)observable.getValue();
            return sourceValue == null ? defaultValue : (Double)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull Function<Double, Double> mapper, @Nonnull Supplier<Double> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Double sourceValue = (Double)observable.getValue();
            return sourceValue == null ? (Double)supplier.get() : (Double)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull ObservableValue<Function<Double, Double>> mapper) {
        return MappingBindings.mapDouble(observable, mapper, (Double)0.0);
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull ObservableValue<Function<Double, Double>> mapper, @Nonnull Double defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Double sourceValue = (Double)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (Double)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<Double> observable, @Nonnull ObservableValue<Function<Double, Double>> mapper, @Nonnull Supplier<Double> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Double sourceValue = (Double)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (Double)supplier.get() : (Double)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull Function<String, String> mapper) {
        return MappingBindings.mapString(observable, mapper, "");
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull Function<String, String> mapper, @Nonnull String defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String sourceValue = (String)observable.getValue();
            return sourceValue == null ? defaultValue : (String)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull Function<String, String> mapper, @Nonnull Supplier<String> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createStringBinding(() -> {
            String sourceValue = (String)observable.getValue();
            return sourceValue == null ? (String)supplier.get() : (String)mapper.apply(sourceValue);
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull ObservableValue<Function<String, String>> mapper) {
        return MappingBindings.mapString(observable, mapper, "");
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull ObservableValue<Function<String, String>> mapper, @Nonnull String defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String sourceValue = (String)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? defaultValue : (String)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static StringBinding mapString(@Nonnull ObservableValue<String> observable, @Nonnull ObservableValue<Function<String, String>> mapper, @Nonnull Supplier<String> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createStringBinding(() -> {
            String sourceValue = (String)observable.getValue();
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return sourceValue == null ? (String)supplier.get() : (String)mapperValue.apply(sourceValue);
        }, (Observable[])new Observable[]{observable, mapper});
    }

    @Nonnull
    public static BooleanBinding mapBooleans(@Nonnull ObservableValue<Boolean> observable1, @Nonnull ObservableValue<Boolean> observable2, @Nonnull Boolean defaultValue, @Nonnull BiFunction<Boolean, Boolean, Boolean> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean value1 = (Boolean)observable1.getValue();
            Boolean value2 = (Boolean)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Boolean)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static BooleanBinding mapBooleans(@Nonnull ObservableValue<Boolean> observable1, @Nonnull ObservableValue<Boolean> observable2, @Nonnull Supplier<Boolean> supplier, @Nonnull BiFunction<Boolean, Boolean, Boolean> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean value1 = (Boolean)observable1.getValue();
            Boolean value2 = (Boolean)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Boolean)mapper.apply(value1, value2);
            }
            return (Boolean)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static BooleanBinding mapBooleans(@Nonnull ObservableValue<Boolean> observable1, @Nonnull ObservableValue<Boolean> observable2, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<BiFunction<Boolean, Boolean, Boolean>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean value1 = (Boolean)observable1.getValue();
            Boolean value2 = (Boolean)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Boolean)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static BooleanBinding mapBooleans(@Nonnull ObservableValue<Boolean> observable1, @Nonnull ObservableValue<Boolean> observable2, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<BiFunction<Boolean, Boolean, Boolean>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Boolean value1 = (Boolean)observable1.getValue();
            Boolean value2 = (Boolean)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Boolean)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (Boolean)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static IntegerBinding mapIntegers(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Integer defaultValue, @Nonnull BiFunction<? super Number, ? super Number, Integer> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Integer)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static IntegerBinding mapIntegers(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Integer> supplier, @Nonnull BiFunction<? super Number, ? super Number, Integer> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Integer)mapper.apply(value1, value2);
            }
            return (Integer)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static IntegerBinding mapIntegers(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Integer defaultValue, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Integer>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Integer)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static IntegerBinding mapIntegers(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Integer>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Integer)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (Integer)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static LongBinding mapLongs(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Long defaultValue, @Nonnull BiFunction<? super Number, ? super Number, Long> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Long)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static LongBinding mapLongs(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Long> supplier, @Nonnull BiFunction<? super Number, ? super Number, Long> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Long)mapper.apply(value1, value2);
            }
            return (Long)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static LongBinding mapLongs(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Long defaultValue, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Long>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Long)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static LongBinding mapLongs(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Long>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Long)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (Long)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static FloatBinding mapFloats(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Float defaultValue, @Nonnull BiFunction<? super Number, ? super Number, Float> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Float)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static FloatBinding mapFloats(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Float> supplier, @Nonnull BiFunction<? super Number, ? super Number, Float> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Float)mapper.apply(value1, value2);
            }
            return (Float)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static FloatBinding mapFloats(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Float defaultValue, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Float>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Float)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static FloatBinding mapFloats(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Float>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Float)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (Float)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static DoubleBinding mapDoubles(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Double defaultValue, @Nonnull BiFunction<? super Number, ? super Number, Double> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Double)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static DoubleBinding mapDoubles(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Double> supplier, @Nonnull BiFunction<? super Number, ? super Number, Double> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (Double)mapper.apply(value1, value2);
            }
            return (Double)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static DoubleBinding mapDoubles(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Double defaultValue, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Double>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Double)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static DoubleBinding mapDoubles(@Nonnull ObservableValue<? extends Number> observable1, @Nonnull ObservableValue<? extends Number> observable2, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<BiFunction<? super Number, ? super Number, Double>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Number value1 = (Number)observable1.getValue();
            Number value2 = (Number)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (Double)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (Double)Objects.requireNonNull(supplier.get(), ERROR_DEFAULT_VALUE_NULL);
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static <A, B, R> ObjectBinding<R> mapObjects(@Nonnull ObservableValue<A> observable1, @Nonnull ObservableValue<B> observable2, @Nullable R defaultValue, @Nonnull BiFunction<? super A, ? super B, R> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object value1 = observable1.getValue();
            Object value2 = observable2.getValue();
            if (value1 != null && value2 != null) {
                return mapper.apply((Object)value1, (Object)value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static <A, B, R> ObjectBinding<R> mapObjects(@Nonnull ObservableValue<A> observable1, @Nonnull ObservableValue<B> observable2, @Nonnull Supplier<R> supplier, @Nonnull BiFunction<? super A, ? super B, R> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object value1 = observable1.getValue();
            Object value2 = observable2.getValue();
            if (value1 != null && value2 != null) {
                return mapper.apply((Object)value1, (Object)value2);
            }
            return supplier.get();
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static <A, B, R> ObjectBinding<R> mapObjects(@Nonnull ObservableValue<A> observable1, @Nonnull ObservableValue<B> observable2, @Nullable R defaultValue, @Nonnull ObservableValue<BiFunction<? super A, ? super B, R>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object value1 = observable1.getValue();
            Object value2 = observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static <A, B, R> ObjectBinding<R> mapObjects(@Nonnull ObservableValue<A> observable1, @Nonnull ObservableValue<B> observable2, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<BiFunction<? super A, ? super B, R>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object value1 = observable1.getValue();
            Object value2 = observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return supplier.get();
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static StringBinding mapStrings(@Nonnull ObservableValue<String> observable1, @Nonnull ObservableValue<String> observable2, @Nullable String defaultValue, @Nonnull BiFunction<String, String, String> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value1 = (String)observable1.getValue();
            String value2 = (String)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (String)mapper.apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static StringBinding mapStrings(@Nonnull ObservableValue<String> observable1, @Nonnull ObservableValue<String> observable2, @Nonnull Supplier<String> supplier, @Nonnull BiFunction<String, String, String> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value1 = (String)observable1.getValue();
            String value2 = (String)observable2.getValue();
            if (value1 != null && value2 != null) {
                return (String)mapper.apply(value1, value2);
            }
            return (String)supplier.get();
        }, (Observable[])new Observable[]{observable1, observable2});
    }

    @Nonnull
    public static StringBinding mapStrings(@Nonnull ObservableValue<String> observable1, @Nonnull ObservableValue<String> observable2, @Nullable String defaultValue, @Nonnull ObservableValue<BiFunction<String, String, String>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value1 = (String)observable1.getValue();
            String value2 = (String)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (String)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return defaultValue;
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static StringBinding mapStrings(@Nonnull ObservableValue<String> observable1, @Nonnull ObservableValue<String> observable2, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<BiFunction<String, String, String>> mapper) {
        Objects.requireNonNull(observable1, ERROR_OBSERVABLE1_NULL);
        Objects.requireNonNull(observable2, ERROR_OBSERVABLE2_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value1 = (String)observable1.getValue();
            String value2 = (String)observable2.getValue();
            if (value1 != null && value2 != null) {
                BiFunction function = (BiFunction)mapper.getValue();
                return (String)Objects.requireNonNull(function, ERROR_MAPPER_NULL).apply(value1, value2);
            }
            return (String)supplier.get();
        }, (Observable[])new Observable[]{observable1, observable2, mapper});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<? extends Number> observable) {
        return MappingBindings.mapInteger(observable, 0);
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<? extends Number> observable, @Nullable Integer defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        if (observable instanceof IntegerBinding) {
            return (IntegerBinding)observable;
        }
        return Bindings.createIntegerBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? value.intValue() : defaultValue.intValue();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static IntegerBinding mapInteger(@Nonnull ObservableValue<? extends Number> observable, @Nullable Supplier<Integer> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        if (observable instanceof IntegerBinding) {
            return (IntegerBinding)observable;
        }
        return Bindings.createIntegerBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? Integer.valueOf(value.intValue()) : (Integer)supplier.get();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<? extends Number> observable) {
        return MappingBindings.mapLong(observable, 0L);
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<? extends Number> observable, @Nullable Long defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        if (observable instanceof LongBinding) {
            return (LongBinding)observable;
        }
        return Bindings.createLongBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? value.longValue() : defaultValue.longValue();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static LongBinding mapLong(@Nonnull ObservableValue<? extends Number> observable, @Nullable Supplier<Long> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        if (observable instanceof LongBinding) {
            return (LongBinding)observable;
        }
        return Bindings.createLongBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? Long.valueOf(value.longValue()) : (Long)supplier.get();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<? extends Number> observable) {
        return MappingBindings.mapFloat(observable, Float.valueOf(0.0f));
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<? extends Number> observable, @Nullable Float defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        if (observable instanceof FloatBinding) {
            return (FloatBinding)observable;
        }
        return Bindings.createFloatBinding(() -> {
            Number value = (Number)observable.getValue();
            return Float.valueOf(value != null ? value.floatValue() : defaultValue.floatValue());
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static FloatBinding mapFloat(@Nonnull ObservableValue<? extends Number> observable, @Nullable Supplier<Float> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        if (observable instanceof FloatBinding) {
            return (FloatBinding)observable;
        }
        return Bindings.createFloatBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? Float.valueOf(value.floatValue()) : (Float)supplier.get();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<? extends Number> observable) {
        return MappingBindings.mapDouble(observable, 0.0);
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<? extends Number> observable, @Nullable Double defaultValue) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        if (observable instanceof DoubleBinding) {
            return (DoubleBinding)observable;
        }
        return Bindings.createDoubleBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? value.doubleValue() : defaultValue.doubleValue();
        }, (Observable[])new Observable[]{observable});
    }

    @Nonnull
    public static DoubleBinding mapDouble(@Nonnull ObservableValue<? extends Number> observable, @Nullable Supplier<Double> supplier) {
        Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        if (observable instanceof DoubleBinding) {
            return (DoubleBinding)observable;
        }
        return Bindings.createDoubleBinding(() -> {
            Number value = (Number)observable.getValue();
            return value != null ? Double.valueOf(value.doubleValue()) : (Double)supplier.get();
        }, (Observable[])new Observable[]{observable});
    }
}

