/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javax.annotation.Nonnull;

public class MapPropertyDecorator<K, V>
extends MapProperty<K, V> {
    private final MapProperty<K, V> delegate;

    public MapPropertyDecorator(@Nonnull MapProperty<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final MapProperty<K, V> getDelegate() {
        return this.delegate;
    }

    public void setValue(ObservableMap<K, V> v) {
        this.delegate.setValue(v);
    }

    public void bindBidirectional(Property<ObservableMap<K, V>> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<ObservableMap<K, V>> other) {
        this.delegate.unbindBidirectional(other);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.delegate.toString();
    }

    public void bindContentBidirectional(ObservableMap<K, V> map) {
        this.delegate.bindContentBidirectional(map);
    }

    public void unbindContentBidirectional(Object object) {
        this.delegate.unbindContentBidirectional(object);
    }

    public void bindContent(ObservableMap<K, V> map) {
        this.delegate.bindContent(map);
    }

    public void unbindContent(Object object) {
        this.delegate.unbindContent(object);
    }

    public ObservableMap<K, V> getValue() {
        return this.delegate.getValue();
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public ReadOnlyIntegerProperty sizeProperty() {
        return this.delegate.sizeProperty();
    }

    public ReadOnlyBooleanProperty emptyProperty() {
        return this.delegate.emptyProperty();
    }

    public ObjectBinding<V> valueAt(K key) {
        return this.delegate.valueAt(key);
    }

    public ObjectBinding<V> valueAt(ObservableValue<K> key) {
        return this.delegate.valueAt(key);
    }

    public BooleanBinding isEqualTo(ObservableMap<?, ?> other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableMap<?, ?> other) {
        return this.delegate.isNotEqualTo(other);
    }

    public BooleanBinding isNull() {
        return this.delegate.isNull();
    }

    public BooleanBinding isNotNull() {
        return this.delegate.isNotNull();
    }

    public StringBinding asString() {
        return this.delegate.asString();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object obj) {
        return this.delegate.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        return this.delegate.containsValue(obj);
    }

    public V put(K key, V value) {
        return (V)this.delegate.put(key, value);
    }

    public V remove(Object obj) {
        return (V)this.delegate.remove(obj);
    }

    public void putAll(Map<? extends K, ? extends V> elements) {
        this.delegate.putAll(elements);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    public Collection<V> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public ObservableMap<K, V> get() {
        return (ObservableMap)this.delegate.get();
    }

    public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(MapChangeListener<? super K, ? super V> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        this.delegate.removeListener(listener);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void bind(ObservableValue<? extends ObservableMap<K, V>> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void set(ObservableMap<K, V> value) {
        this.delegate.set(value);
    }
}

