/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;

public class ListPropertyDecorator<E>
extends ListProperty<E> {
    private final ListProperty<E> delegate;

    public ListPropertyDecorator(@Nonnull ListProperty<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final ListProperty<E> getDelegate() {
        return this.delegate;
    }

    public void setValue(ObservableList<E> v) {
        this.delegate.setValue(v);
    }

    public void bindBidirectional(Property<ObservableList<E>> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<ObservableList<E>> other) {
        this.delegate.unbindBidirectional(other);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.delegate.toString();
    }

    public void bindContentBidirectional(ObservableList<E> list) {
        this.delegate.bindContentBidirectional(list);
    }

    public void unbindContentBidirectional(Object object) {
        this.delegate.unbindContentBidirectional(object);
    }

    public void bindContent(ObservableList<E> list) {
        this.delegate.bindContent(list);
    }

    public void unbindContent(Object object) {
        this.delegate.unbindContent(object);
    }

    public ObservableList<E> getValue() {
        return this.delegate.getValue();
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public ReadOnlyIntegerProperty sizeProperty() {
        return this.delegate.sizeProperty();
    }

    public ReadOnlyBooleanProperty emptyProperty() {
        return this.delegate.emptyProperty();
    }

    public ObjectBinding<E> valueAt(int index) {
        return this.delegate.valueAt(index);
    }

    public ObjectBinding<E> valueAt(ObservableIntegerValue index) {
        return this.delegate.valueAt(index);
    }

    public BooleanBinding isEqualTo(ObservableList<?> other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableList<?> other) {
        return this.delegate.isNotEqualTo(other);
    }

    public BooleanBinding isNull() {
        return this.delegate.isNull();
    }

    public BooleanBinding isNotNull() {
        return this.delegate.isNotNull();
    }

    public StringBinding asString() {
        return this.delegate.asString();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object obj) {
        return this.delegate.contains(obj);
    }

    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] array) {
        return this.delegate.toArray((Object[])array);
    }

    public boolean add(E element) {
        return this.delegate.add(element);
    }

    public boolean remove(Object obj) {
        return this.delegate.remove(obj);
    }

    public boolean containsAll(Collection<?> objects) {
        return this.delegate.containsAll(objects);
    }

    public boolean addAll(Collection<? extends E> elements) {
        return this.delegate.addAll(elements);
    }

    public boolean addAll(int i, Collection<? extends E> elements) {
        return this.delegate.addAll(i, elements);
    }

    public boolean removeAll(Collection<?> objects) {
        return this.delegate.removeAll(objects);
    }

    public boolean retainAll(Collection<?> objects) {
        return this.delegate.retainAll(objects);
    }

    public void clear() {
        this.delegate.clear();
    }

    public E get(int i) {
        return (E)this.delegate.get(i);
    }

    public E set(int i, E element) {
        return (E)this.delegate.set(i, element);
    }

    public void add(int i, E element) {
        this.delegate.add(i, element);
    }

    public E remove(int i) {
        return (E)this.delegate.remove(i);
    }

    public int indexOf(Object obj) {
        return this.delegate.indexOf(obj);
    }

    public int lastIndexOf(Object obj) {
        return this.delegate.lastIndexOf(obj);
    }

    public ListIterator<E> listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator<E> listIterator(int i) {
        return this.delegate.listIterator(i);
    }

    public List<E> subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    public boolean addAll(E[] elements) {
        return this.delegate.addAll((Object[])elements);
    }

    public boolean setAll(E[] elements) {
        return this.delegate.setAll((Object[])elements);
    }

    public boolean setAll(Collection<? extends E> elements) {
        return this.delegate.setAll(elements);
    }

    public boolean removeAll(E[] elements) {
        return this.delegate.removeAll((Object[])elements);
    }

    public boolean retainAll(E[] elements) {
        return this.delegate.retainAll((Object[])elements);
    }

    public void remove(int from, int to) {
        this.delegate.remove(from, to);
    }

    public ObservableList<E> get() {
        return (ObservableList)this.delegate.get();
    }

    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        this.delegate.removeListener(listener);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void bind(ObservableValue<? extends ObservableList<E>> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void set(ObservableList<E> value) {
        this.delegate.set(value);
    }
}

