/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;

public final class FilteringBindings {
    private static final String ERROR_ITEMS_NULL = "Argument 'items' must not be null";
    private static final String ERROR_FILTER_NULL = "Argument 'filter' must not be null";
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    private static final String ERROR_SUPPLIER_NULL = "Argument 'supplier' must not be null";

    private FilteringBindings() {
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull T defaultValue, @Nonnull Predicate<? super T> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull Predicate<? super T> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull T defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableList<Boolean> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableList<Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableList<Boolean> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableList<Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableList<Integer> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableList<Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableList<Integer> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableList<Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableList<Long> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableList<Long> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableList<Long> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableList<Long> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableList<Float> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableList<Float> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableList<Float> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableList<Float> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableList<Double> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableList<Double> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableList<Double> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableList<Double> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableList<String> items, @Nonnull String defaultValue, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableList<String> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableList<String> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableList<String> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull T defaultValue, @Nonnull Predicate<? super T> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull Predicate<? super T> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull T defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <T> ObjectBinding<T> filterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<T> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableSet<Boolean> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableSet<Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableSet<Boolean> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableSet<Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableSet<Integer> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableSet<Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableSet<Integer> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableSet<Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableSet<Long> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableSet<Long> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableSet<Long> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static LongBinding filterThenFindFirstLong(@Nonnull ObservableSet<Long> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableSet<Float> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableSet<Float> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableSet<Float> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static FloatBinding filterThenFindFirstFloat(@Nonnull ObservableSet<Float> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableSet<Double> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableSet<Double> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableSet<Double> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableSet<Double> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableSet<String> items, @Nonnull String defaultValue, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableSet<String> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableSet<String> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static StringBinding filterThenFindFirstString(@Nonnull ObservableSet<String> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> filterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull V defaultValue, @Nonnull Predicate<? super V> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> filterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull Predicate<? super V> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> filterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull V defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K, V> ObjectBinding<V> filterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<V> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableMap<K, Boolean> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableMap<K, Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableMap<K, Boolean> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> BooleanBinding filterThenFindFirstBoolean(@Nonnull ObservableMap<K, Boolean> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableMap<K, Integer> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableMap<K, Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableMap<K, Integer> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> IntegerBinding filterThenFindFirstInteger(@Nonnull ObservableMap<K, Integer> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> LongBinding filterThenFindFirstLong(@Nonnull ObservableMap<K, Long> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> LongBinding filterThenFindFirstLong(@Nonnull ObservableMap<K, Long> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> LongBinding filterThenFindFirstLong(@Nonnull ObservableMap<K, Long> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> LongBinding filterThenFindFirstLong(@Nonnull ObservableMap<K, Long> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> FloatBinding filterThenFindFirstFloat(@Nonnull ObservableMap<K, Float> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> FloatBinding filterThenFindFirstFloat(@Nonnull ObservableMap<K, Float> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> FloatBinding filterThenFindFirstFloat(@Nonnull ObservableMap<K, Float> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> FloatBinding filterThenFindFirstFloat(@Nonnull ObservableMap<K, Float> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableMap<K, Double> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableMap<K, Double> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableMap<K, Double> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> DoubleBinding filterThenFindFirstDouble(@Nonnull ObservableMap<K, Double> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> StringBinding filterThenFindFirstString(@Nonnull ObservableMap<K, String> items, @Nonnull String defaultValue, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.values().stream().filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> StringBinding filterThenFindFirstString(@Nonnull ObservableMap<K, String> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.values().stream().filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> StringBinding filterThenFindFirstString(@Nonnull ObservableMap<K, String> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <K> StringBinding filterThenFindFirstString(@Nonnull ObservableMap<K, String> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.values().stream().filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull R defaultValue, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Boolean defaultValue, @Nonnull Function<? super T, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super T, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Integer defaultValue, @Nonnull Function<? super T, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super T, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Long defaultValue, @Nonnull Function<? super T, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super T, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Float defaultValue, @Nonnull Function<? super T, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super T, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Double defaultValue, @Nonnull Function<? super T, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super T, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull String defaultValue, @Nonnull Function<? super T, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super T, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull R defaultValue, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super T, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super T, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Boolean defaultValue, @Nonnull Function<? super T, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super T, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Integer defaultValue, @Nonnull Function<? super T, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super T, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super T, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Long defaultValue, @Nonnull Function<? super T, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super T, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super T, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Float defaultValue, @Nonnull Function<? super T, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super T, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super T, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Double defaultValue, @Nonnull Function<? super T, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super T, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super T, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull String defaultValue, @Nonnull Function<? super T, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super T, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super T, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull R defaultValue, @Nonnull Function<? super V, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull Function<? super V, R> mapper, @Nonnull Predicate<? super R> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> mapThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Function<? super V, R>> mapper, @Nonnull ObservableValue<Predicate<? super R>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Boolean defaultValue, @Nonnull Function<? super V, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Function<? super V, Boolean> mapper, @Nonnull Predicate<Boolean> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> BooleanBinding mapToBooleanThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper, @Nonnull ObservableValue<Predicate<Boolean>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Integer defaultValue, @Nonnull Function<? super V, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull Function<? super V, Integer> mapper, @Nonnull Predicate<Integer> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Function<? super V, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> IntegerBinding mapToIntegerThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Function<? super V, Integer>> mapper, @Nonnull ObservableValue<Predicate<Integer>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Long defaultValue, @Nonnull Function<? super V, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull Function<? super V, Long> mapper, @Nonnull Predicate<Long> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Function<? super V, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> LongBinding mapToLongThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Function<? super V, Long>> mapper, @Nonnull ObservableValue<Predicate<Long>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Float defaultValue, @Nonnull Function<? super V, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull Function<? super V, Float> mapper, @Nonnull Predicate<Float> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Function<? super V, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> FloatBinding mapToFloatThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Function<? super V, Float>> mapper, @Nonnull ObservableValue<Predicate<Float>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Double defaultValue, @Nonnull Function<? super V, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull Function<? super V, Double> mapper, @Nonnull Predicate<Double> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Function<? super V, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> DoubleBinding mapToDoubleThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Function<? super V, Double>> mapper, @Nonnull ObservableValue<Predicate<Double>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull String defaultValue, @Nonnull Function<? super V, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> items.values().stream().map(mapper).filter(filter).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull Function<? super V, String> mapper, @Nonnull Predicate<String> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> (String)items.values().stream().map(mapper).filter(filter).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Function<? super V, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> StringBinding mapToStringThenFilterThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Function<? super V, String>> mapper, @Nonnull ObservableValue<Predicate<String>> filter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.values().stream().map(mapperValue).filter(filterValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull R defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull String defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableList<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull R defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull String defaultValue, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> items.stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <T> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableSet<T> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super T>> filter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull R defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, R> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull R defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V, R> ObjectBinding<R> filterThenMapThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<R> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, R>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createObjectBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Boolean defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Boolean> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> (Boolean)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Boolean defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> BooleanBinding filterThenMapToBooleanThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Boolean> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Boolean>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createBooleanBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Boolean)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Integer defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Integer> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> (Integer)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Integer defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> IntegerBinding filterThenMapToIntegerThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Integer> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Integer>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createIntegerBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Integer)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Long defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Long> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> (Long)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Long defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> LongBinding filterThenMapToLongThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Long> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Long>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createLongBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Long)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Float defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Float> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> (Float)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Float defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> FloatBinding filterThenMapToFloatThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Float> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Float>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createFloatBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Float)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Double defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, Double> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> (Double)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Double defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> DoubleBinding filterThenMapToDoubleThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<Double> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, Double>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (Double)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull String defaultValue, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> items.values().stream().filter(filter).map(mapper).findFirst().orElse(defaultValue), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull Predicate<? super V> filter, @Nonnull Function<? super V, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> (String)items.values().stream().filter(filter).map(mapper).findFirst().orElseGet(supplier), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull String defaultValue, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElse(defaultValue);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }

    @Nonnull
    public static <K, V> StringBinding filterThenMapToStringThenFindFirst(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<String> supplier, @Nonnull ObservableValue<Predicate<? super V>> filter, @Nonnull ObservableValue<Function<? super V, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(filter, ERROR_FILTER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            Function mapperValue = (Function)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            Predicate filterValue = (Predicate)filter.getValue();
            Objects.requireNonNull(filterValue, ERROR_FILTER_NULL);
            return (String)items.values().stream().filter(filterValue).map(mapperValue).findFirst().orElseGet(supplier);
        }, (Observable[])new Observable[]{items, mapper, filter});
    }
}

