/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CollectionBindings {
    private static final String ERROR_ITEMS_NULL = "Argument 'items' must not be null";
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    private static final String ERROR_SUPPLIER_NULL = "Argument 'supplier' must not be null";
    private static final String ERROR_DELIMITER_NULL = "Argument 'delimiter' must not be null";
    private static final String ERROR_DEFAULT_VALUE_NULL = "Argument 'defaultValue' must not be null";

    private CollectionBindings() {
    }

    @Nonnull
    public static StringBinding joinList(@Nonnull ObservableList<?> items, @Nullable String delimiter) {
        return CollectionBindings.joinList(items, delimiter, String::valueOf);
    }

    @Nonnull
    public static <T> StringBinding joinList(@Nonnull ObservableList<T> items, @Nullable String delimiter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        String value = delimiter == null ? "" : delimiter;
        return Bindings.createStringBinding(() -> items.stream().map(mapper).collect(Collectors.joining(value)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding joinList(@Nonnull ObservableList<?> items, @Nonnull ObservableValue<String> delimiter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            return items.stream().map(String::valueOf).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter});
    }

    @Nonnull
    public static <T> StringBinding joinList(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<String> delimiter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return items.stream().map(mapperValue).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter, mapper});
    }

    @Nonnull
    public static StringBinding joinSet(@Nonnull ObservableSet<?> items, @Nullable String delimiter) {
        return CollectionBindings.joinSet(items, delimiter, String::valueOf);
    }

    @Nonnull
    public static <T> StringBinding joinSet(@Nonnull ObservableSet<T> items, @Nullable String delimiter, @Nonnull Function<? super T, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        String value = delimiter == null ? "" : delimiter;
        return Bindings.createStringBinding(() -> items.stream().map(mapper).collect(Collectors.joining(value)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static StringBinding joinSet(@Nonnull ObservableSet<?> items, @Nonnull ObservableValue<String> delimiter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            return items.stream().map(String::valueOf).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter});
    }

    @Nonnull
    public static <T> StringBinding joinSet(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<String> delimiter, @Nonnull ObservableValue<Function<? super T, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : String::valueOf;
            return items.stream().map(mapperValue).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter, mapper});
    }

    @Nonnull
    public static <K, V> StringBinding joinMap(@Nonnull ObservableMap<K, V> items, @Nullable String delimiter) {
        return CollectionBindings.joinMap(items, delimiter, (Map.Entry<K, V> entry) -> String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
    }

    @Nonnull
    public static <K, V> StringBinding joinMap(@Nonnull ObservableMap<K, V> items, @Nullable String delimiter, @Nonnull Function<Map.Entry<K, V>, String> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        String value = delimiter == null ? "," : delimiter;
        return Bindings.createStringBinding(() -> items.entrySet().stream().map(mapper).collect(Collectors.joining(value)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> StringBinding joinMap(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<String> delimiter) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        Function<Map.Entry, String> mapper = entry -> String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue());
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            return items.entrySet().stream().map(mapper).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter});
    }

    @Nonnull
    public static <K, V> StringBinding joinMap(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<String> delimiter, @Nonnull ObservableValue<Function<Map.Entry<K, V>, String>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(delimiter, ERROR_DELIMITER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        Function<Map.Entry, String> mv = entry -> String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue());
        return Bindings.createStringBinding(() -> {
            String value = (String)delimiter.getValue();
            value = value == null ? "" : value;
            Function mapperValue = mapper.getValue() != null ? (Function)mapper.getValue() : mv;
            return items.entrySet().stream().map(mapperValue).collect(Collectors.joining(value));
        }, (Observable[])new Observable[]{items, delimiter, mapper});
    }

    @Nonnull
    public static NumberBinding minInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding minInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding maxInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding maxInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding averageInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding averageInList(@Nonnull ObservableList<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding sumOfList(@Nonnull ObservableList<? extends Number> items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding maxInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding maxInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding averageInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding averageInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding sumOfList(@Nonnull ObservableList<T> items, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).min().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding minInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding maxInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).max().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding maxInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding averageInList(@Nonnull ObservableList<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).average().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding averageInList(@Nonnull ObservableList<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding sumOfList(@Nonnull ObservableList<T> items, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).sum();
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static NumberBinding minInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding minInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding maxInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding maxInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding averageInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding averageInSet(@Nonnull ObservableSet<? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static NumberBinding sumOfSet(@Nonnull ObservableSet<? extends Number> items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(Number::doubleValue).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding maxInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding maxInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding averageInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding averageInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding sumOfSet(@Nonnull ObservableSet<T> items, @Nonnull ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.stream().mapToDouble(mapper).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <T> NumberBinding minInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).min().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding minInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding maxInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).max().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding maxInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding averageInSet(@Nonnull ObservableSet<T> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).average().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding averageInSet(@Nonnull ObservableSet<T> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <T> NumberBinding sumOfSet(@Nonnull ObservableSet<T> items, @Nonnull ObservableValue<ToDoubleFunction<? super T>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.stream().mapToDouble(mapperValue).sum();
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K> NumberBinding minInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding minInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding maxInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding maxInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding averageInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Number defaultValue) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding averageInMap(@Nonnull ObservableMap<K, ? extends Number> items, @Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K> NumberBinding sumOfMap(@Nonnull ObservableMap<K, ? extends Number> items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(Number::doubleValue).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding minInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).min().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding minInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding maxInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).max().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding maxInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding averageInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).average().orElse(defaultValue.doubleValue()), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding averageInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier)), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding sumOfMap(@Nonnull ObservableMap<K, V> items, @Nonnull ToDoubleFunction<? super V> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> items.values().stream().mapToDouble(mapper).sum(), (Observable[])new Observable[]{items});
    }

    @Nonnull
    public static <K, V> NumberBinding minInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).min().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding minInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).min().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding maxInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).max().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding maxInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).max().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding averageInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Number defaultValue, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(defaultValue, ERROR_DEFAULT_VALUE_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).average().orElse(defaultValue.doubleValue());
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding averageInMap(@Nonnull ObservableMap<K, V> items, @Nonnull Supplier<? extends Number> supplier, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).average().orElseGet(CollectionBindings.resolveDoubleSupplier(supplier));
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    public static <K, V> NumberBinding sumOfMap(@Nonnull ObservableMap<K, V> items, @Nonnull ObservableValue<ToDoubleFunction<? super V>> mapper) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return Bindings.createDoubleBinding(() -> {
            ToDoubleFunction mapperValue = (ToDoubleFunction)mapper.getValue();
            Objects.requireNonNull(mapperValue, ERROR_MAPPER_NULL);
            return items.values().stream().mapToDouble(mapperValue).sum();
        }, (Observable[])new Observable[]{items, mapper});
    }

    @Nonnull
    private static DoubleSupplier resolveDoubleSupplier(@Nonnull Supplier<? extends Number> supplier) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return () -> ((Number)supplier.get()).doubleValue();
    }
}

