/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class BooleanPropertyDecorator
extends BooleanProperty {
    private final BooleanProperty delegate;

    public BooleanPropertyDecorator(@Nonnull BooleanProperty delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
    }

    @Nonnull
    protected final BooleanProperty getDelegate() {
        return this.delegate;
    }

    public void setValue(Boolean v) {
        this.delegate.setValue(v);
    }

    public void bindBidirectional(Property<Boolean> other) {
        this.delegate.bindBidirectional(other);
    }

    public void unbindBidirectional(Property<Boolean> other) {
        this.delegate.unbindBidirectional(other);
    }

    public boolean equals(Object o) {
        return this == o || this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.delegate.toString();
    }

    public ObjectProperty<Boolean> asObject() {
        return this.delegate.asObject();
    }

    public Boolean getValue() {
        return this.delegate.getValue();
    }

    public BooleanBinding and(ObservableBooleanValue other) {
        return this.delegate.and(other);
    }

    public BooleanBinding or(ObservableBooleanValue other) {
        return this.delegate.or(other);
    }

    public BooleanBinding not() {
        return this.delegate.not();
    }

    public BooleanBinding isEqualTo(ObservableBooleanValue other) {
        return this.delegate.isEqualTo(other);
    }

    public BooleanBinding isNotEqualTo(ObservableBooleanValue other) {
        return this.delegate.isNotEqualTo(other);
    }

    public StringBinding asString() {
        return this.delegate.asString();
    }

    public boolean get() {
        return this.delegate.get();
    }

    public void addListener(ChangeListener<? super Boolean> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super Boolean> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void bind(ObservableValue<? extends Boolean> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public void set(boolean value) {
        this.delegate.set(value);
    }
}

