/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import griffon.util.GriffonClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.codehaus.griffon.runtime.core.injection.InjectionUnitOfWork;

class InstanceTracker {
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private static final String ERROR_BINDING_NULL = "Argument 'binding' must not be null";
    private final Map<Object, Binding<?>> instanceToKeyMap = Collections.synchronizedMap(new LinkedHashMap());
    private Injector injector;

    InstanceTracker() {
    }

    public void setInjector(@Nonnull Injector injector) {
        this.injector = injector;
    }

    @Nonnull
    public Injector getInjector() {
        return this.injector;
    }

    @Nonnull
    public <T> T track(@Nonnull Binding<?> binding, @Nonnull T instance) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        if (GriffonClassUtils.hasMethodAnnotatedwith(instance, PreDestroy.class)) {
            if (Scopes.isSingleton(binding)) {
                this.instanceToKeyMap.put(instance, binding);
            } else {
                try {
                    InjectionUnitOfWork.track(instance);
                }
                catch (IllegalStateException ise) {
                    this.instanceToKeyMap.put(instance, binding);
                }
            }
        }
        return instance;
    }

    public <T> void release(@Nonnull T instance) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        GriffonClassUtils.invokeAnnotatedMethod(instance, PreDestroy.class);
        Binding<?> binding = this.instanceToKeyMap.get(instance);
        if (binding != null) {
            this.instanceToKeyMap.remove(instance);
        }
    }

    public void releaseAll() {
        ArrayList<Object> instances = new ArrayList<Object>(this.instanceToKeyMap.keySet());
        this.instanceToKeyMap.clear();
        Collections.reverse(instances);
        for (Object e : instances) {
            GriffonClassUtils.invokeAnnotatedMethod(e, PreDestroy.class);
        }
        instances.clear();
    }
}

