/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import griffon.core.injection.Binding;
import griffon.core.injection.InstanceBinding;
import griffon.core.injection.ProviderBinding;
import griffon.core.injection.ProviderTypeBinding;
import griffon.core.injection.Qualified;
import griffon.core.injection.TargetBinding;
import griffon.exceptions.ClosedInjectorException;
import griffon.exceptions.InstanceNotFoundException;
import griffon.exceptions.MembersInjectionException;
import griffon.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.codehaus.griffon.runtime.injection.InstanceTracker;

public class GuiceInjector
implements griffon.core.injection.Injector<Injector> {
    private static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    private static final String ERROR_DELEGATE_NULL = "Argument 'delegate' must not be null";
    private static final String ERROR_INSTANCE_TRACKER_NULL = "Argument 'instanceTracker' must not be null";
    private static final String ERROR_QUALIFIER_NULL = "Argument 'qualifier' must not be null";
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private final InstanceTracker instanceTracker;
    private final Injector delegate;
    private final Object lock = new Object[0];
    @GuardedBy(value="lock")
    private boolean closed;

    public GuiceInjector(@Nonnull InstanceTracker instanceTracker) {
        this.instanceTracker = Objects.requireNonNull(instanceTracker, ERROR_INSTANCE_TRACKER_NULL);
        this.delegate = Objects.requireNonNull(instanceTracker.getInjector(), ERROR_DELEGATE_NULL);
    }

    static Module moduleFromBindings(final @Nonnull Iterable<Binding<?>> bindings) {
        return new AbstractModule(){

            protected void configure() {
                for (Binding binding : bindings) {
                    if (binding instanceof TargetBinding) {
                        this.handleTargetBinding((TargetBinding)binding);
                        continue;
                    }
                    if (binding instanceof InstanceBinding) {
                        this.handleInstanceBinding((InstanceBinding)binding);
                        continue;
                    }
                    if (binding instanceof ProviderTypeBinding) {
                        this.handleProviderTypeBinding((ProviderTypeBinding)binding);
                        continue;
                    }
                    if (binding instanceof ProviderBinding) {
                        this.handleProviderBinding((ProviderBinding)binding);
                        continue;
                    }
                    throw new IllegalArgumentException("Don't know how to handle " + binding);
                }
            }

            @Nonnull
            private LinkedBindingBuilder handleBinding(@Nonnull Binding<?> binding) {
                AnnotatedBindingBuilder builder = this.bind(binding.getSource());
                if (binding.getClassifier() != null) {
                    return builder.annotatedWith(binding.getClassifier());
                }
                if (binding.getClassifierType() != null) {
                    return builder.annotatedWith(binding.getClassifierType());
                }
                return builder;
            }

            private void handleTargetBinding(@Nonnull TargetBinding<?> binding) {
                LinkedBindingBuilder lbuilder = this.handleBinding((Binding<?>)binding);
                if (binding.getSource() != binding.getTarget()) {
                    ScopedBindingBuilder sbuilder = lbuilder.to(binding.getTarget());
                    if (binding.isSingleton()) {
                        sbuilder.in(Singleton.class);
                    }
                } else if (binding.isSingleton()) {
                    lbuilder.in(Singleton.class);
                }
            }

            private void handleInstanceBinding(@Nonnull InstanceBinding<?> binding) {
                this.handleBinding((Binding<?>)binding).toInstance(binding.getInstance());
            }

            private void handleProviderTypeBinding(@Nonnull ProviderTypeBinding<?> binding) {
                ScopedBindingBuilder builder = this.handleBinding((Binding<?>)binding).toProvider(binding.getProviderType());
                if (binding.isSingleton()) {
                    builder.in(Singleton.class);
                }
            }

            private void handleProviderBinding(@Nonnull ProviderBinding<?> binding) {
                ScopedBindingBuilder builder = this.handleBinding((Binding<?>)binding).toProvider(Providers.guicify((Provider)binding.getProvider()));
                if (binding.isSingleton()) {
                    builder.in(Singleton.class);
                }
            }
        };
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> type) throws InstanceNotFoundException {
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(type, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            return (T)this.delegate.getInstance(type);
        }
        catch (RuntimeException e) {
            throw new InstanceNotFoundException(type, (Throwable)e);
        }
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> type, @Nonnull Annotation qualifier) throws InstanceNotFoundException {
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        Objects.requireNonNull(qualifier, ERROR_QUALIFIER_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(type, qualifier, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            return (T)this.delegate.getInstance(Key.get(type, (Annotation)qualifier));
        }
        catch (RuntimeException e) {
            throw new InstanceNotFoundException(type, qualifier, (Throwable)e);
        }
    }

    @Nonnull
    public <T> Collection<T> getInstances(@Nonnull Class<T> type) throws InstanceNotFoundException {
        List bindings;
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(type, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        try {
            bindings = this.delegate.findBindingsByType(TypeLiteral.get(type));
        }
        catch (RuntimeException e) {
            throw new InstanceNotFoundException(type, (Throwable)e);
        }
        if (bindings == null) {
            throw new InstanceNotFoundException(type);
        }
        for (com.google.inject.Binding binding : bindings) {
            try {
                instances.add(this.delegate.getInstance(binding.getKey()));
            }
            catch (RuntimeException e) {
                throw new InstanceNotFoundException(type, (Throwable)e);
            }
        }
        return instances;
    }

    @Nonnull
    public <T> Collection<Qualified<T>> getQualifiedInstances(@Nonnull Class<T> type) throws InstanceNotFoundException {
        List bindings;
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(type, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        ArrayList<Qualified<T>> instances = new ArrayList<Qualified<T>>();
        try {
            bindings = this.delegate.findBindingsByType(TypeLiteral.get(type));
        }
        catch (RuntimeException e) {
            throw new InstanceNotFoundException(type, (Throwable)e);
        }
        if (bindings == null) {
            throw new InstanceNotFoundException(type);
        }
        for (com.google.inject.Binding binding : bindings) {
            try {
                Key key = binding.getKey();
                Object instance = this.delegate.getInstance(key);
                instances.add(new Qualified(instance, this.translate(key.getAnnotation())));
            }
            catch (RuntimeException e) {
                throw new InstanceNotFoundException(type, (Throwable)e);
            }
        }
        return instances;
    }

    @Nullable
    private Annotation translate(@Nullable Annotation annotation) {
        if (annotation instanceof Named) {
            return AnnotationUtils.named((String)((Named)annotation).value());
        }
        return annotation;
    }

    public void injectMembers(@Nonnull Object instance) throws MembersInjectionException {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        if (this.isClosed()) {
            throw new MembersInjectionException(instance, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            this.delegate.injectMembers(instance);
        }
        catch (RuntimeException e) {
            throw new MembersInjectionException(instance, (Throwable)e);
        }
    }

    @Nonnull
    public Injector getDelegateInjector() {
        return this.delegate;
    }

    public void release(@Nonnull Object instance) {
        this.instanceTracker.release(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            throw new ClosedInjectorException((griffon.core.injection.Injector)this);
        }
        this.instanceTracker.releaseAll();
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }
}

