/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public class ClassWrangler {
    private String groovyVersion = null;
    private Boolean isIndy = null;
    private final ClassLoader classLoader;
    private final Log log;

    public ClassWrangler(List<?> classpath, ClassLoader parentClassLoader, Log pluginLog) throws MalformedURLException {
        this.log = pluginLog;
        this.classLoader = this.createNewClassLoader(classpath, parentClassLoader);
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public String getGroovyVersionString() {
        if (this.groovyVersion == null) {
            String ver;
            try {
                Class<?> groovySystemClass = this.getClass("groovy.lang.GroovySystem");
                ver = (String)ReflectionUtils.invokeStaticMethod(ReflectionUtils.findMethod(groovySystemClass, "getVersion", new Class[0]), new Object[0]);
                if (ver != null && ver.length() > 0) {
                    this.groovyVersion = ver;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException groovySystemClass) {
                // empty catch block
            }
            if (this.groovyVersion == null) {
                this.log.info((CharSequence)"Unable to get Groovy version from GroovySystem, trying InvokerHelper.");
                try {
                    Class<?> invokerHelperClass = this.getClass("org.codehaus.groovy.runtime.InvokerHelper");
                    ver = (String)ReflectionUtils.invokeStaticMethod(ReflectionUtils.findMethod(invokerHelperClass, "getVersion", new Class[0]), new Object[0]);
                    if (ver != null && ver.length() > 0) {
                        this.groovyVersion = ver;
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException invokerHelperClass) {
                    // empty catch block
                }
            }
            if (this.groovyVersion == null) {
                this.log.warn((CharSequence)"Unable to get Groovy version from InvokerHelper or GroovySystem, trying jar name.");
                String jar = this.getGroovyJar();
                int idx = Integer.MAX_VALUE;
                for (int i = 0; i < 9; ++i) {
                    int newIdx = jar.indexOf("-" + i);
                    if (newIdx < 0 || newIdx >= idx) continue;
                    idx = newIdx;
                }
                if (idx < Integer.MAX_VALUE) {
                    this.groovyVersion = jar.substring(idx + 1, jar.length() - 4).replace("-indy", "").replace("-grooid", "");
                }
            }
        }
        return this.groovyVersion;
    }

    public Version getGroovyVersion() {
        try {
            return Version.parseFromString(this.getGroovyVersionString());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine Groovy version. Is Groovy declared as a dependency?");
        }
    }

    public static boolean groovyAtLeast(Version detectedVersion, Version compareToVersion) {
        return detectedVersion.compareTo(compareToVersion) >= 0;
    }

    public static boolean groovyIs(Version detectedVersion, Version compareToVersion) {
        return detectedVersion.compareTo(compareToVersion) == 0;
    }

    public static boolean groovyNewerThan(Version detectedVersion, Version compareToVersion) {
        return detectedVersion.compareTo(compareToVersion) > 0;
    }

    public static boolean groovyOlderThan(Version detectedVersion, Version compareToVersion) {
        return detectedVersion.compareTo(compareToVersion) < 0;
    }

    public boolean isGroovyIndy() {
        if (this.isIndy == null) {
            try {
                this.getClass("org.codehaus.groovy.vmplugin.v8.IndyInterface");
                this.isIndy = true;
            }
            catch (ClassNotFoundException e1) {
                try {
                    this.getClass("org.codehaus.groovy.vmplugin.v7.IndyInterface");
                    this.isIndy = true;
                }
                catch (ClassNotFoundException e2) {
                    this.isIndy = false;
                }
            }
        }
        return this.isIndy;
    }

    public void logGroovyVersion(String goal) {
        this.log.info((CharSequence)("Using Groovy " + this.getGroovyVersionString() + " to perform " + goal + "."));
    }

    public Class<?> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected ClassLoader createNewClassLoader(List<?> classpath, ClassLoader classLoader) throws MalformedURLException {
        ArrayList<URL> urlsList = new ArrayList<URL>();
        for (Object classPathObject : classpath) {
            String path = (String)classPathObject;
            urlsList.add(new File(path).toURI().toURL());
        }
        URL[] urlsArray = urlsList.toArray(new URL[0]);
        return new URLClassLoader(urlsArray, classLoader);
    }

    protected String getGroovyJar() {
        try {
            String groovyObjectClassPath = this.getJarPath();
            String groovyJar = null;
            if (groovyObjectClassPath != null) {
                groovyJar = groovyObjectClassPath.replaceAll("!.+", "");
                groovyJar = groovyJar.substring(groovyJar.lastIndexOf("/") + 1);
            }
            return groovyJar;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to determine Groovy version. Is Groovy declared as a dependency?");
        }
    }

    protected String getJarPath() throws ClassNotFoundException {
        CodeSource codeSource;
        Class<?> groovyObjectClass = this.getClass("groovy.lang.GroovyObject");
        String groovyObjectClassPath = String.valueOf(groovyObjectClass.getResource("/" + groovyObjectClass.getName().replace('.', '/') + ".class"));
        if (groovyObjectClassPath == null && (codeSource = groovyObjectClass.getProtectionDomain().getCodeSource()) != null) {
            groovyObjectClassPath = String.valueOf(codeSource.getLocation());
        }
        return groovyObjectClassPath;
    }
}

