/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGenerateStubsMojo;

@Mojo(name="generateStubs", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateStubsMojo
extends AbstractGenerateStubsMojo {
    private static final Version GROOVY_1_8_2 = new Version(1, 8, 2);
    @Parameter(defaultValue="${project.build.directory}/generated-sources/groovy-stubs/main")
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.minGroovyVersion = GROOVY_1_8_2;
        try {
            try {
                this.getLog().debug((CharSequence)("Project compile classpath:\n" + this.project.getCompileClasspathElements()));
            }
            catch (DependencyResolutionRequiredException e) {
                this.getLog().warn((CharSequence)"Unable to log project compile classpath", (Throwable)e);
            }
            this.doStubGeneration(this.getSources(), this.project.getCompileClasspathElements(), this.outputDirectory);
            this.logGeneratedStubs(this.outputDirectory);
            this.resetStubModifiedDates(this.getStubs(this.outputDirectory));
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project?", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Compile dependencies weren't resolved.", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to add project compile dependencies to classpath.", (Exception)e);
        }
    }
}

