/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

@Mojo(name="execute", requiresDependencyResolution=ResolutionScope.TEST, configurator="include-project-test-dependencies", threadSafe=true)
public class ExecuteMojo
extends AbstractToolsMojo {
    @Parameter(required=true)
    protected String[] scripts;
    @Parameter(defaultValue="false")
    protected boolean continueExecuting;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    protected synchronized void doExecute() throws MojoExecutionException, MojoFailureException {
        this.classWrangler = new ClassWrangler(Thread.currentThread().getContextClassLoader(), this.getLog());
        if (this.scripts == null || this.scripts.length == 0) {
            this.getLog().info((CharSequence)"No scripts specified for execution.  Skipping.");
            return;
        }
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        try {
            this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((CharSequence)"Unable to log project test classpath", (Throwable)e);
        }
        if (this.groovyVersionSupportsAction()) {
            SecurityManager sm = System.getSecurityManager();
            try {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object shell = this.setupShell(groovyShellClass);
                this.executeScripts(groovyShellClass, shell);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            finally {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(sm);
                }
            }
        } else {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support script execution.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping script execution."));
        }
    }

    protected Object setupShell(Class<?> groovyShellClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object shell;
        if (this.sourceEncoding != null) {
            Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
            Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
            shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, compilerConfigurationClass), compilerConfiguration);
        } else {
            shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, new Class[0]), new Object[0]);
        }
        this.initializeProperties();
        Method setProperty = ReflectionUtils.findMethod(groovyShellClass, "setProperty", String.class, Object.class);
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(setProperty, shell, k, this.properties.get(k));
            }
        } else {
            ReflectionUtils.invokeMethod(setProperty, shell, "properties", this.properties);
        }
        return shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScripts(Class<?> groovyShellClass, Object shell) throws InvocationTargetException, IllegalAccessException, MojoExecutionException {
        Method evaluateUrl = ReflectionUtils.findMethod(groovyShellClass, "evaluate", Reader.class);
        Method evaluateFile = ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class);
        Method evaluateString = ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class);
        int scriptNum = 1;
        for (String script : this.scripts) {
            block9: {
                try {
                    BufferedReader reader = null;
                    try {
                        URL url = new URL(script);
                        try {
                            reader = this.sourceEncoding != null ? new BufferedReader(new InputStreamReader(url.openStream(), this.sourceEncoding)) : new BufferedReader(new InputStreamReader(url.openStream()));
                            ReflectionUtils.invokeMethod(evaluateUrl, shell, reader);
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeQuietly(reader);
                            throw throwable;
                        }
                        FileUtils.closeQuietly(reader);
                    }
                    catch (MalformedURLException e) {
                        File scriptFile = new File(script);
                        if (scriptFile.isFile()) {
                            ReflectionUtils.invokeMethod(evaluateFile, shell, scriptFile);
                            break block9;
                        }
                        ReflectionUtils.invokeMethod(evaluateString, shell, script);
                    }
                }
                catch (IOException ioe) {
                    if (this.continueExecuting) {
                        this.getLog().error((CharSequence)("An Exception occurred while executing script " + scriptNum + ".  Continuing to execute remaining scripts."), (Throwable)ioe);
                    }
                    throw new MojoExecutionException("An Exception occurred while executing script " + scriptNum + ".", (Exception)ioe);
                }
            }
            ++scriptNum;
        }
    }
}

