/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.groovyworkarounds.GroovyDocTemplateInfo;
import org.codehaus.gmavenplus.model.Scopes;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.mojo.Link;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public abstract class AbstractGroovyDocMojo
extends AbstractGroovySourcesMojo {
    protected static final Version GROOVY_1_6_0_RC2 = new Version(1, 6, 0, "RC-2");
    protected static final Version GROOVY_1_6_0_RC1 = new Version(1, 6, 0, "RC-1");
    protected static final Version GROOVY_1_5_8 = new Version(1, 5, 8);
    protected static final Version GROOVY_1_5_2 = new Version(1, 5, 2);
    @Parameter(defaultValue="${project.build.directory}/gapidocs")
    protected File groovyDocOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/testgapidocs")
    protected File testGroovyDocOutputDirectory;
    @Parameter(defaultValue="Groovy Documentation")
    protected String windowTitle;
    @Parameter(defaultValue="Groovy Documentation")
    protected String docTitle;
    @Parameter(defaultValue="Groovy Documentation")
    protected String footer;
    @Parameter(defaultValue="Groovy Documentation")
    protected String header;
    @Parameter(defaultValue="true")
    protected boolean displayAuthor;
    @Parameter
    protected File overviewFile;
    @Parameter
    protected File stylesheetFile;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String stylesheetEncoding;
    @Parameter(defaultValue="private")
    protected String scope;
    @Parameter
    protected List<Link> links;
    @Parameter(defaultValue="true")
    protected boolean groovyDocJavaSources;
    @Parameter(property="maven.groovydoc.skip", defaultValue="false")
    protected boolean skipGroovyDoc;

    protected synchronized void doGroovyDocGeneration(FileSet[] sourceDirectories, List classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        this.classWrangler = new ClassWrangler(classpath, this.getLog());
        if (this.skipGroovyDoc) {
            this.getLog().info((CharSequence)"Skipping generation of GroovyDoc because ${maven.groovydoc.skip} was set to true.");
            return;
        }
        if (sourceDirectories == null || sourceDirectories.length == 0) {
            this.getLog().info((CharSequence)"No source directories specified for GroovyDoc generation.  Skipping.");
            return;
        }
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        this.logPluginClasspath();
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support GroovyDoc.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping GroovyDoc generation."));
            return;
        }
        if (this.groovyIs(GROOVY_1_6_0_RC1) || this.groovyIs(GROOVY_1_5_8)) {
            this.getLog().warn((CharSequence)("Groovy " + GROOVY_1_5_8 + " and " + GROOVY_1_6_0_RC1 + " are blacklisted from the supported GroovyDoc versions because of their dependency on Ant.  Skipping GroovyDoc generation."));
            return;
        }
        Class<?> groovyDocToolClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.GroovyDocTool");
        Class<?> outputToolClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.OutputTool");
        Class<?> fileOutputToolClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.FileOutputTool");
        Class<?> resourceManagerClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.ResourceManager");
        Class<?> classpathResourceManagerClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.ClasspathResourceManager");
        Properties docProperties = this.setupProperties();
        Object fileOutputTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(fileOutputToolClass, new Class[0]), new Object[0]);
        Object classpathResourceManager = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(classpathResourceManagerClass, new Class[0]), new Object[0]);
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        ArrayList<String> sourceDirectoriesStrings = new ArrayList<String>();
        for (FileSet sourceDirectory : sourceDirectories) {
            sourceDirectoriesStrings.add(sourceDirectory.getDirectory());
        }
        GroovyDocTemplateInfo groovyDocTemplateInfo = new GroovyDocTemplateInfo(this.classWrangler.getGroovyVersion());
        List groovyDocLinks = this.setupLinks();
        if (this.groovyOlderThan(GROOVY_1_6_0_RC2)) {
            this.getLog().warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support GroovyDoc documentation properties (docTitle, footer, header, displayAuthor, overviewFile, and scope).  You need Groovy 1.6-RC-2 or newer to support this.  Ignoring properties."));
        }
        List<String> groovyDocSources = this.setupGroovyDocSources(sourceDirectories, fileSetManager);
        Object groovyDocTool = this.createGroovyDocTool(groovyDocToolClass, resourceManagerClass, docProperties, classpathResourceManager, sourceDirectoriesStrings, groovyDocTemplateInfo, groovyDocLinks);
        this.generateGroovyDoc(outputDirectory, groovyDocToolClass, outputToolClass, fileOutputTool, groovyDocSources, groovyDocTool);
        if (this.stylesheetFile != null) {
            this.copyStylesheet(outputDirectory);
        }
    }

    protected Properties setupProperties() {
        Properties properties = new Properties();
        properties.setProperty("windowTitle", this.windowTitle);
        properties.setProperty("docTitle", this.docTitle);
        properties.setProperty("footer", this.footer);
        properties.setProperty("header", this.header);
        properties.setProperty("author", Boolean.toString(this.displayAuthor));
        properties.setProperty("overviewFile", this.overviewFile != null ? this.overviewFile.getAbsolutePath() : "");
        try {
            Scopes scopeVal = Scopes.valueOf(this.scope.toUpperCase());
            if (scopeVal.equals((Object)Scopes.PUBLIC)) {
                properties.setProperty("publicScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PROTECTED)) {
                properties.setProperty("protectedScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PACKAGE)) {
                properties.setProperty("packageScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PRIVATE)) {
                properties.setProperty("privateScope", "true");
            }
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Scope (" + this.scope + ") was not recognized.  Skipping argument."));
        }
        return properties;
    }

    protected List setupLinks() throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ArrayList<Object> linksList = new ArrayList<Object>();
        if (this.links != null && this.links.size() > 0) {
            Class<?> linkArgumentClass = null;
            if (this.groovyAtLeast(GROOVY_1_6_0_RC2)) {
                linkArgumentClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.LinkArgument");
            } else if (this.groovyAtLeast(GROOVY_1_5_2)) {
                linkArgumentClass = this.classWrangler.getClass("org.codehaus.groovy.ant.Groovydoc$LinkArgument");
            }
            if (linkArgumentClass != null) {
                Method setHref = ReflectionUtils.findMethod(linkArgumentClass, "setHref", String.class);
                Method setPackages = ReflectionUtils.findMethod(linkArgumentClass, "setPackages", String.class);
                for (Link link : this.links) {
                    Object linkArgument = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(linkArgumentClass, new Class[0]), new Object[0]);
                    ReflectionUtils.invokeMethod(setHref, linkArgument, link.getHref());
                    ReflectionUtils.invokeMethod(setPackages, linkArgument, link.getPackages());
                    linksList.add(linkArgument);
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use GroovyDoc links, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be 1.5.2 or newer).  Ignoring links parameter."));
            }
        }
        return linksList;
    }

    protected Object createGroovyDocTool(Class<?> groovyDocToolClass, Class<?> resourceManagerClass, Properties docProperties, Object classpathResourceManager, List<String> sourceDirectories, GroovyDocTemplateInfo groovyDocTemplateInfo, List groovyDocLinks) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object groovyDocTool;
        if (this.groovyAtLeast(GROOVY_1_6_0_RC2)) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String[].class, String[].class, String[].class, String[].class, List.class, Properties.class), classpathResourceManager, sourceDirectories.toArray(new String[sourceDirectories.size()]), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates(), groovyDocLinks, docProperties);
        } else if (this.groovyAtLeast(GROOVY_1_5_2)) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class, List.class), classpathResourceManager, sourceDirectories.get(0), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates(), groovyDocLinks);
            if (sourceDirectories.size() > 1) {
                this.getLog().warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support more than one GroovyDoc source directory (must be 1.6-RC-2 or newer).  Only using first source directory (" + sourceDirectories.get(0) + ")."));
            }
        } else {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class), classpathResourceManager, sourceDirectories.get(0), groovyDocTemplateInfo.defaultDocTemplates(), groovyDocTemplateInfo.defaultPackageTemplates(), groovyDocTemplateInfo.defaultClassTemplates());
            if (sourceDirectories.size() > 1) {
                this.getLog().warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support more than one GroovyDoc source directory (must be 1.6-RC-2 or newer).  Only using first source directory (" + sourceDirectories.get(0) + ")."));
            }
        }
        return groovyDocTool;
    }

    protected List<String> setupGroovyDocSources(FileSet[] sourceDirectories, FileSetManager fileSetManager) {
        ArrayList<String> javaSources = new ArrayList<String>();
        ArrayList<String> groovySources = new ArrayList<String>();
        ArrayList<String> possibleGroovyStubs = new ArrayList<String>();
        for (FileSet sourceDirectory : sourceDirectories) {
            List<String> sources = Arrays.asList(fileSetManager.getIncludedFiles(sourceDirectory));
            for (String source : sources) {
                if (source.endsWith(".java") && !javaSources.contains(source)) {
                    javaSources.add(source);
                    continue;
                }
                if (groovySources.contains(source)) continue;
                groovySources.add(source);
                possibleGroovyStubs.add(source.replaceFirst("\\." + FileUtils.getFileExtension(source), ".java"));
            }
        }
        javaSources.removeAll(possibleGroovyStubs);
        ArrayList<String> groovyDocSources = new ArrayList<String>();
        groovyDocSources.addAll(javaSources);
        groovyDocSources.addAll(groovySources);
        return groovyDocSources;
    }

    protected void generateGroovyDoc(File outputDirectory, Class<?> groovyDocToolClass, Class<?> outputToolClass, Object fileOutputTool, List<String> groovyDocSources, Object groovyDocTool) throws InvocationTargetException, IllegalAccessException {
        this.getLog().debug((CharSequence)"Adding sources to generate GroovyDoc for:");
        if (this.getLog().isDebugEnabled()) {
            for (String groovyDocSource : groovyDocSources) {
                this.getLog().debug((CharSequence)("    " + groovyDocSource));
            }
        }
        if (this.groovyAtLeast(GROOVY_1_6_0_RC2)) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "add", List.class), groovyDocTool, groovyDocSources);
        } else {
            Method add = ReflectionUtils.findMethod(groovyDocToolClass, "add", String.class);
            for (String groovyDocSource : groovyDocSources) {
                ReflectionUtils.invokeMethod(add, groovyDocTool, groovyDocSource);
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "renderToOutput", outputToolClass, String.class), groovyDocTool, fileOutputTool, outputDirectory.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStylesheet(File outputDirectory) {
        this.getLog().info((CharSequence)("Using stylesheet from " + this.stylesheetFile.getAbsolutePath() + "."));
        try {
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                String line;
                bufferedReader = this.stylesheetEncoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stylesheetFile), this.stylesheetEncoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.stylesheetFile)));
                StringBuilder css = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    css.append(line).append("\n");
                }
                File outfile = new File(outputDirectory, "stylesheet.css");
                bufferedWriter = this.stylesheetEncoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), this.stylesheetEncoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outfile)));
                bufferedWriter.write(css.toString());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(bufferedReader);
                FileUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
            FileUtils.closeQuietly(bufferedReader);
            FileUtils.closeQuietly(bufferedWriter);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to copy specified stylesheet (" + this.stylesheetFile.getAbsolutePath() + ")."));
        }
    }
}

