/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public class ExecuteMojo
extends AbstractToolsMojo {
    protected String[] scripts;
    protected boolean continueExecuting;
    protected String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.classWrangler = new ClassWrangler(Thread.currentThread().getContextClassLoader(), this.getLog());
        if (this.groovyVersionSupportsAction()) {
            this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
            this.logPluginClasspath();
            if (this.getLog().isDebugEnabled()) {
                try {
                    this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
                }
                catch (DependencyResolutionRequiredException e) {
                    this.getLog().warn((CharSequence)"Unable to log project test classpath", (Throwable)e);
                }
            }
            if (this.scripts == null || this.scripts.length == 0) {
                this.getLog().info((CharSequence)"No scripts specified for execution.  Skipping.");
                return;
            }
            SecurityManager sm = System.getSecurityManager();
            try {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                Class groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object shell = this.setupShell(groovyShellClass);
                this.executeScripts(groovyShellClass, shell);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            finally {
                System.setSecurityManager(sm);
            }
        }
        this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersion() + ") doesn't support script execution.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping script execution."));
    }

    protected Object setupShell(Class groovyShellClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, new Class[0]), new Object[0]);
        this.initializeProperties();
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "setProperty", String.class, Object.class), shell, k, this.properties.get(k));
            }
        } else {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "setProperty", String.class, Object.class), shell, "properties", this.properties);
        }
        return shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScripts(Class groovyShellClass, Object shell) throws InvocationTargetException, IllegalAccessException, MojoExecutionException {
        int scriptNum = 1;
        for (String script : this.scripts) {
            try {
                BufferedReader reader = null;
                try {
                    String line;
                    URL url = new URL(script);
                    this.getLog().info((CharSequence)("Fetching Groovy script from " + url.toString() + "."));
                    reader = this.sourceEncoding != null ? new BufferedReader(new InputStreamReader(url.openStream(), this.sourceEncoding)) : new BufferedReader(new InputStreamReader(url.openStream()));
                    StringBuilder scriptSource = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        scriptSource.append(line).append("\n");
                    }
                    if (scriptSource.toString().length() != 0) {
                        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class), shell, scriptSource.toString());
                    }
                    FileUtils.closeQuietly(reader);
                }
                catch (MalformedURLException e) {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class), shell, script);
                }
                finally {
                    FileUtils.closeQuietly(reader);
                }
            }
            catch (IOException ioe) {
                if (this.continueExecuting) {
                    this.getLog().error((CharSequence)("An Exception occurred while executing script " + scriptNum + ".  Continuing to execute remaining scripts."), (Throwable)ioe);
                }
                throw new MojoExecutionException("An Exception occurred while executing script " + scriptNum + ".", (Exception)ioe);
            }
            ++scriptNum;
        }
    }
}

