/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public class ExecuteMojo
extends AbstractToolsMojo {
    protected String[] scripts;
    protected boolean continueExecuting;
    protected String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.groovyVersionSupportsAction()) {
            this.logGroovyVersion("execute");
            if (this.scripts == null || this.scripts.length == 0) {
                this.getLog().info((CharSequence)"No scripts specified for execution.  Skipping.");
                return;
            }
            try {
                Class<?> groovyShellClass = Class.forName("groovy.lang.GroovyShell");
                Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, new Class[0]), new Object[0]);
                this.initializeProperties();
                for (Object k : this.properties.keySet()) {
                    String key = (String)k;
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "setProperty", String.class, Object.class), shell, key, this.properties.get(key));
                }
                int scriptNum = 1;
                for (String script : this.scripts) {
                    Closer closer = Closer.create();
                    try {
                        try {
                            String line;
                            URL url = new URL(script);
                            this.getLog().info((CharSequence)("Fetching Groovy script from " + url.toString() + "."));
                            BufferedReader reader = this.sourceEncoding != null ? (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(url.openStream(), this.sourceEncoding))) : (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(url.openStream())));
                            StringBuilder scriptSource = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                scriptSource.append(line).append("\n");
                            }
                            if (!scriptSource.toString().isEmpty()) {
                                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class), shell, scriptSource.toString());
                            }
                        }
                        catch (MalformedURLException e) {
                            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class), shell, script);
                        }
                        catch (Throwable throwable) {
                            throw closer.rethrow(throwable);
                        }
                        finally {
                            closer.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (this.continueExecuting) {
                            this.getLog().error((CharSequence)("An Exception occurred while executing script " + scriptNum + ".  Continuing to execute remaining scripts."), (Throwable)ioe);
                        }
                        throw new MojoExecutionException("An Exception occurred while executing script " + scriptNum + ".", (Exception)ioe);
                    }
                    ++scriptNum;
                }
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
        }
        this.getLog().error((CharSequence)("Your Groovy version (" + this.getGroovyVersion() + ") doesn't support script execution.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping script execution."));
    }
}

