/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.gmavenplus.model.Version;

public abstract class AbstractGroovyMojo
extends AbstractMojo {
    protected static final String GROOVY_SOURCES_PATTERN = "**" + File.separator + "*.groovy";
    protected static final String JAVA_SOURCES_PATTERN = "**" + File.separator + "*.java";
    protected MavenProject project;
    protected MavenSession session;
    protected Settings settings;
    protected List<Artifact> pluginArtifacts;
    protected ArtifactRepository localRepository;
    protected List<MavenProject> reactorProjects;
    protected Version minGroovyVersion = new Version(1, 5, 0);

    protected void logGroovyVersion(String goal) {
        if (this.getLog().isInfoEnabled()) {
            String logMessage = "Using Groovy " + this.getGroovyVersion();
            if (this.isGroovyIndy()) {
                logMessage = logMessage + "-indy";
            }
            this.getLog().info((CharSequence)(logMessage + " from project compile classpath to perform " + goal + "."));
        }
    }

    protected String getGroovyVersionString() {
        String groovyVersion = null;
        Artifact groovyDependency = this.getGroovyDependency();
        if (groovyDependency == null) {
            this.getLog().error((CharSequence)"Unable to determine Groovy version.  Is Groovy declared as a dependency?");
        } else {
            groovyVersion = groovyDependency.getVersion();
        }
        return groovyVersion;
    }

    protected Version getGroovyVersion() {
        try {
            return Version.parseFromString(this.getGroovyVersionString());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to determine Groovy version.  Is Groovy declared as a dependency?");
            return null;
        }
    }

    protected boolean isGroovyIndy() {
        boolean isGroovyIndy = false;
        Artifact groovyDependency = this.getGroovyDependency();
        if (groovyDependency == null) {
            this.getLog().error((CharSequence)"Unable to determine Groovy version.  Is Groovy declared as a dependency?");
        } else if ("indy".equals(groovyDependency.getClassifier())) {
            isGroovyIndy = true;
        }
        return isGroovyIndy;
    }

    protected Artifact getGroovyDependency() {
        Dependency dependency;
        Artifact groovyDependency = null;
        if (this.pluginArtifacts != null) {
            for (Artifact art : this.pluginArtifacts) {
                Artifact artifact = art;
                if (!this.isGroovyGroupId(artifact) || !this.isGroovyArtifactId(artifact) || !artifact.getType().equals("jar")) continue;
                groovyDependency = artifact;
                break;
            }
        }
        if (groovyDependency == null && this.project.getCompileDependencies() != null) {
            for (Object dep : this.project.getCompileDependencies()) {
                dependency = (Dependency)dep;
                if (!this.isGroovyGroupId(dependency) || !this.isGroovyArtifactId(dependency) || !dependency.getType().equals("jar")) continue;
                groovyDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), dependency.getScope(), dependency.getType(), dependency.getClassifier() != null ? dependency.getClassifier() : "", null);
                break;
            }
        }
        if (groovyDependency == null && this.project.getTestDependencies() != null) {
            for (Object dep : this.project.getTestDependencies()) {
                dependency = (Dependency)dep;
                if (!this.isGroovyGroupId(dependency) || !this.isGroovyArtifactId(dependency) || !dependency.getType().equals("jar")) continue;
                groovyDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), dependency.getScope(), dependency.getType(), dependency.getClassifier() != null ? dependency.getClassifier() : "", null);
                break;
            }
        }
        return groovyDependency;
    }

    protected boolean isGroovyGroupId(Dependency dependency) {
        return dependency.getGroupId().equals("org.codehaus.groovy") || dependency.getGroupId().equals("groovy");
    }

    protected boolean isGroovyArtifactId(Dependency dependency) {
        return dependency.getArtifactId().equals("groovy-all") || dependency.getArtifactId().equals("groovy-all-minimal") || dependency.getArtifactId().equals("groovy") || dependency.getArtifactId().equals("groovy-all-jdk14") || dependency.getArtifactId().equals("groovy-jdk14");
    }

    protected boolean isGroovyGroupId(Artifact artifact) {
        return artifact.getGroupId().equals("org.codehaus.groovy") || artifact.getGroupId().equals("groovy");
    }

    protected boolean isGroovyArtifactId(Artifact artifact) {
        return artifact.getArtifactId().equals("groovy-all") || artifact.getArtifactId().equals("groovy-all-minimal") || artifact.getArtifactId().equals("groovy") || artifact.getArtifactId().equals("groovy-all-jdk14") || artifact.getArtifactId().equals("groovy-jdk14");
    }

    protected boolean isJavaSupportIndy() {
        return this.getJavaVersion().compareTo(new Version(1, 7), false) >= 0;
    }

    protected Version getJavaVersion() {
        return Version.parseFromString(this.getJavaVersionString());
    }

    protected String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    protected boolean groovyVersionSupportsAction() {
        return this.getGroovyVersion() != null && this.getGroovyVersion().compareTo(this.minGroovyVersion) >= 0;
    }
}

