/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.model;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int revision;
    private String tag;

    public Version(int newMajor, int newMinor, int newRevision, String newTag) {
        if (newMajor < 0 || newMinor < 0 || newRevision < 0) {
            throw new IllegalArgumentException("Major must be >= 0 and minor >= 0 and revision >= 0.");
        }
        this.major = newMajor;
        this.minor = newMinor;
        this.revision = newRevision;
        if (newTag == null || !newTag.isEmpty()) {
            this.tag = newTag;
        } else if (newTag.isEmpty()) {
            this.tag = null;
        }
    }

    public Version(int newMajor, int newMinor, int newRevision) {
        this(newMajor, newMinor, newRevision, null);
    }

    public Version(int newMajor, int newMinor) {
        this(newMajor, newMinor, 0);
    }

    public Version(int newMajor) {
        this(newMajor, 0);
    }

    public static Version parseFromString(String version) {
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Version must not be null or empty.");
        }
        String[] split = version.split("[._-]", 4);
        try {
            int tagIdx = 3;
            int major = Integer.parseInt(split[0]);
            int minor = 0;
            int revision = 0;
            StringBuilder tag = new StringBuilder();
            if (split.length >= 2) {
                try {
                    minor = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException nfe) {
                    tag.append(split[1]);
                    tagIdx = 1;
                    tag.append("-");
                }
            }
            if (split.length >= 3) {
                try {
                    revision = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException nfe) {
                    tag.append(split[2]);
                    tagIdx = 2;
                    tag.append("-");
                }
            }
            if (split.length >= 4) {
                for (int i = tagIdx; i < split.length; ++i) {
                    if (i > tagIdx) {
                        tag.append("-");
                    }
                    tag.append(split[i]);
                }
            }
            return new Version(major, minor, revision, tag.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Major, minor, and revision must be integers.", e);
        }
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.revision, this.tag});
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return this.major == other.major && this.minor == other.minor && this.revision == other.revision && Objects.equal((Object)this.tag, (Object)other.tag);
        }
        return false;
    }

    public final String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.major).append(".").append(this.minor).append(".").append(this.revision);
        if (this.tag != null) {
            buff.append("-").append(this.tag);
        }
        return buff.toString();
    }

    @Override
    public final int compareTo(Version version) {
        return this.compareTo(version, true);
    }

    public final int compareTo(Version version, boolean noTagsAreNewer) {
        if (noTagsAreNewer) {
            return ComparisonChain.start().compare(this.major, version.major).compare(this.minor, version.minor).compare(this.revision, version.revision).compare((Object)(this.tag != null ? this.tag.replace("beta", " beta") : this.tag), (Object)(version.tag != null ? version.tag.replace("beta", " beta") : version.tag), (Comparator)Ordering.natural().nullsLast()).result();
        }
        return ComparisonChain.start().compare(this.major, version.major).compare(this.minor, version.minor).compare(this.revision, version.revision).compare((Object)(this.tag != null ? this.tag.replace("beta", " beta") : this.tag), (Object)(version.tag != null ? version.tag.replace("beta", " beta") : version.tag), (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public int getMajor() {
        return this.major;
    }

    public Version setMajor(int newMajor) {
        this.major = newMajor;
        return this;
    }

    public int getMinor() {
        return this.minor;
    }

    public Version setMinor(int newMinor) {
        this.minor = newMinor;
        return this;
    }

    public int getRevision() {
        return this.revision;
    }

    public Version setRevision(int newRevision) {
        this.revision = newRevision;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public Version setTag(String newTag) {
        this.tag = newTag;
        return this;
    }
}

