/*
 * Decompiled with CFR 0.152.
 */
package org.codefetti.proxy.handler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DefaultMethodInvocationHandlerJdk9Plus
implements InvocationHandler {
    private final InvocationHandler delegate;
    private final Map<Integer, MethodHandle> methodHandleCache = new ConcurrentHashMap<Integer, MethodHandle>();

    DefaultMethodInvocationHandlerJdk9Plus(InvocationHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.isDefault()) {
            return this.delegate.invoke(proxy, method, args);
        }
        int defaultMethodHash = this.createHash(proxy, method);
        MethodHandle methodHandle = this.methodHandleCache.get(defaultMethodHash);
        if (methodHandle != null) {
            return methodHandle.invokeWithArguments(args);
        }
        return this.invokeJdk9Plus(defaultMethodHash, proxy, method, args);
    }

    private Object invokeJdk9Plus(int methodHash, Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = MethodHandles.lookup().findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
        MethodHandle boundMethodHandle = methodHandle.bindTo(proxy);
        this.methodHandleCache.put(methodHash, boundMethodHandle);
        return boundMethodHandle.invokeWithArguments(args);
    }

    private int createHash(Object proxy, Method method) {
        return Objects.hash(proxy, method.getDeclaringClass(), method.getReturnType(), method.getName(), Objects.hash(method.getParameterTypes()));
    }
}

