/*
 * Decompiled with CFR 0.152.
 */
package org.codefetti.proxy.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;

public class ObjectMethodInvocationHandler
implements InvocationHandler {
    private static final Method TO_STRING = ObjectMethodInvocationHandler.getObjectMethod("toString", new Class[0]);
    private static final Method EQUALS = ObjectMethodInvocationHandler.getObjectMethod("equals", Object.class);
    private static final Method HASH_CODE = ObjectMethodInvocationHandler.getObjectMethod("hashCode", new Class[0]);
    private InvocationHandler delegate;
    private Class<?> proxyInterface;

    public ObjectMethodInvocationHandler(Class<?> proxyInterface, InvocationHandler delegate) {
        this.delegate = delegate;
        this.proxyInterface = proxyInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            if (TO_STRING.equals(method)) {
                return "Proxy(" + this.proxyInterface.getSimpleName() + ")";
            }
            if (EQUALS.equals(method)) {
                return args[0] != null && (proxy == args[0] || proxy.hashCode() == args[0].hashCode());
            }
            if (HASH_CODE.equals(method)) {
                return Objects.hash(this.proxyInterface, this.delegate);
            }
        }
        return this.delegate.invoke(proxy, method, args);
    }

    static Method getObjectMethod(String name, Class ... types) {
        try {
            return Object.class.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find method " + name + " in Object.", e);
        }
    }
}

