/*
 * Decompiled with CFR 0.152.
 */
package org.codefetti.proxy.handler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DefaultMethodInvocationHandlerJdk8
implements InvocationHandler {
    private InvocationHandler delegate;
    private Map<Integer, MethodHandle> methodHandleCache = new ConcurrentHashMap<Integer, MethodHandle>();
    private Constructor<MethodHandles.Lookup> lookupConstructor;

    DefaultMethodInvocationHandlerJdk8(InvocationHandler delegate) {
        this.delegate = delegate;
        this.lookupConstructor = this.initLookupConstructorForJdk8();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.isDefault()) {
            return this.delegate.invoke(proxy, method, args);
        }
        int defaultMethodHash = this.createHash(proxy, method);
        MethodHandle methodHandle = this.methodHandleCache.get(defaultMethodHash);
        if (methodHandle != null) {
            return methodHandle.invokeWithArguments(args);
        }
        if (this.lookupConstructor != null) {
            return this.invokeJdk8(defaultMethodHash, proxy, method, args);
        }
        throw new UnsupportedOperationException("Failed to invoke default method " + method + ". Maybe there are security restrictions in the JVM that prevent using setAccessible(true) for MethodHandles.Lookup(Class<?>, int). In this environment proxied interfaces can't declare default methods.");
    }

    private Object invokeJdk8(int methodHash, Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = this.lookupConstructor.newInstance(declaringClass, 2);
        MethodHandles.Lookup in = lookup.in(declaringClass);
        MethodHandle methodHandle = in.unreflectSpecial(method, declaringClass);
        MethodHandle boundMethodHandle = methodHandle.bindTo(proxy);
        this.methodHandleCache.put(methodHash, boundMethodHandle);
        return boundMethodHandle.invokeWithArguments(args);
    }

    private int createHash(Object proxy, Method method) {
        return Objects.hash(proxy, method.getDeclaringClass(), method.getReturnType(), method.getName(), Objects.hash(method.getParameterTypes()));
    }

    private Constructor<MethodHandles.Lookup> initLookupConstructorForJdk8() {
        try {
            Constructor<MethodHandles.Lookup> lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            lookupConstructor.setAccessible(true);
            return lookupConstructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalAccessError("Unexpected Api: MethodHandles.Lookup has not the expected Constructor MethodHandles.Lookup(Class, int)");
        }
        catch (SecurityException ignored) {
            return null;
        }
    }
}

