/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.automation;

import cloudreports.models.CloudletRegistry;
import cloudreports.models.CustomerRegistry;
import cloudreports.models.DatacenterRegistry;
import cloudreports.models.HostRegistry;
import cloudreports.models.SanStorageRegistry;
import cloudreports.models.VmRegistry;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.cloudsimplus.automation.YamlCloudScenario;

public class YamlCloudScenarioReader {
    private final File file;
    private final List<YamlCloudScenario> scenarios;

    public YamlCloudScenarioReader(String filePath) throws IllegalArgumentException, FileNotFoundException, YamlException {
        this.file = new File(filePath);
        if (filePath == null || "".equals(filePath)) {
            throw new IllegalArgumentException("You must specify an YAML file, containing the CloudSim simulation scenario, as command line parameter.");
        }
        this.scenarios = this.readYamlFile();
    }

    private List<YamlCloudScenario> readYamlFile() throws FileNotFoundException, YamlException {
        YamlCloudScenario scenario;
        ArrayList<YamlCloudScenario> scenariosList = new ArrayList<YamlCloudScenario>();
        YamlReader reader = this.createYamlReader();
        while ((scenario = (YamlCloudScenario)reader.read(YamlCloudScenario.class)) != null) {
            scenariosList.add(scenario);
        }
        return scenariosList;
    }

    private YamlReader createYamlReader() throws FileNotFoundException {
        YamlReader reader = new YamlReader((Reader)new FileReader(this.file));
        YamlConfig cfg = reader.getConfig();
        cfg.setClassTag("datacenter", DatacenterRegistry.class);
        cfg.setClassTag("customer", CustomerRegistry.class);
        cfg.setClassTag("san", SanStorageRegistry.class);
        cfg.setClassTag("host", HostRegistry.class);
        cfg.setClassTag("cloudlet", CloudletRegistry.class);
        cfg.setClassTag("vm", VmRegistry.class);
        return reader;
    }

    public File getFile() {
        return this.file;
    }

    public List<YamlCloudScenario> getScenarios() {
        return this.scenarios;
    }
}

