/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.automation;

import com.esotericsoftware.yamlbeans.YamlException;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.cloudsimplus.automation.CloudSimulation;
import org.cloudsimplus.automation.YamlCloudScenario;
import org.cloudsimplus.automation.YamlCloudScenarioReader;

public final class Start {
    private Options options;
    private YamlCloudScenarioReader reader;
    private CommandLine cmd;

    public static void main(String[] args) {
        new Start(args);
    }

    private Start(String[] args) {
        try {
            if (!this.parseCommandLineOptions(args)) {
                return;
            }
            this.reader = new YamlCloudScenarioReader(this.getFileNameFromCommandLine());
            if (this.reader.getScenarios().isEmpty()) {
                System.err.println("Your YAML file is empty.\n");
            }
            this.build();
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            System.err.printf("%s", e.getMessage());
        }
        catch (YamlException e) {
            System.err.printf("Error trying to parse the YAML file: %s\n", e.getMessage());
        }
        catch (ParseException e) {
            System.err.printf("Error parsing command line arguments. %s\n", e.getMessage());
        }
        catch (Exception e) {
            System.err.printf("An unexpected error happened: %s\n", e.getMessage());
        }
    }

    private void showUsageHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getApplicationStartCmd() + " [options] YamlFilePath", this.options);
    }

    private boolean parseCommandLineOptions(String[] args) throws ParseException {
        this.options = new Options();
        Option option = new Option("v", "Enables CloudSim Plus Log (disabled by default)");
        option.setLongOpt("verbose");
        this.options.addOption(option);
        this.options.addOption("s", "Suppress simulation results");
        this.options.addOption("h", "Show usage help");
        this.options.addOption("c", "Print scenario configuration");
        DefaultParser parser = new DefaultParser();
        this.cmd = parser.parse(this.options, args);
        if (this.cmd.getArgs().length == 0 || this.cmd.hasOption("h")) {
            this.showUsageHelp();
            return false;
        }
        return true;
    }

    private String getApplicationStartCmd() {
        String fullClassFilePath = this.getFullClassFilePath();
        String jarRegex = ".*\\/(.*\\.jar).*\\/";
        String jarFile = this.regexMatch(".*\\/(.*\\.jar).*\\/", fullClassFilePath);
        return jarFile.isEmpty() ? "java " + Start.class.getName() : "java -jar " + jarFile;
    }

    private String regexMatch(String regex, String text) {
        Matcher matcher = Pattern.compile(regex).matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String getFullClassFilePath() {
        String classFileName = "/" + Start.class.getName().replace('.', '/') + ".class";
        return Start.class.getResource(classFileName).getFile();
    }

    public void build() {
        System.out.printf("Starting %d Simulation Scenario(s) from file %s in CloudSim Plus %s\n", this.reader.getScenarios().size(), this.reader.getFile(), "CloudSim Plus 8.0.0");
        int i = 0;
        for (YamlCloudScenario scenario : this.reader.getScenarios()) {
            String scenarioName = String.format("%d - %s", i++, this.reader.getFile().getName());
            new CloudSimulation(scenario, scenarioName).setShowResults(!this.cmd.hasOption("s")).setLogEnabled(this.isToEnableLog()).setPrintScenariosConfiguration(this.isToPrintScenariosConfiguration()).run();
        }
    }

    private String getFileNameFromCommandLine() {
        return this.cmd.getArgs().length > 0 ? this.cmd.getArgs()[0] : "";
    }

    private boolean isToEnableLog() {
        return this.cmd.hasOption("v");
    }

    private boolean isToPrintScenariosConfiguration() {
        return this.cmd.hasOption("c");
    }
}

