/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.automation;

import cloudreports.models.DatacenterRegistry;
import cloudreports.models.HostRegistry;
import cloudreports.models.VmRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.provisioners.PeProvisioner;
import org.cloudsimplus.provisioners.ResourceProvisioner;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.schedulers.vm.VmScheduler;
import org.cloudsimplus.utilizationmodels.UtilizationModel;

public class PolicyLoader {
    private static final Map<String, Class> map = new HashMap<String, Class>();
    private static final String PKG = "org.cloudsimplus";

    private static <T> Class<T> loadClass(String fullClassName) {
        Class<?> klass = map.get(fullClassName);
        if (klass == null) {
            try {
                klass = Class.forName(fullClassName);
                map.put(fullClassName, klass);
                return klass;
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, e);
                throw new RuntimeException(e);
            }
        }
        return klass;
    }

    public static VmScheduler vmScheduler(String classSuffix) throws RuntimeException {
        try {
            String className = PolicyLoader.generateFullClassName("org.cloudsimplus.schedulers.vm", "VmScheduler", classSuffix);
            Class klass = PolicyLoader.loadClass(className);
            Constructor constructor = klass.getConstructor(new Class[0]);
            return (VmScheduler)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private static <T extends ResourceProvisioner> T resourceProvisioner(String classPrefix, String classSufix) throws RuntimeException {
        try {
            String className = PolicyLoader.generateFullProvisionerClassName(classPrefix, classSufix);
            Class<T> klass = PolicyLoader.loadClass(className);
            Constructor<T> constructor = klass.getConstructor(new Class[0]);
            return (T)((ResourceProvisioner)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static ResourceProvisioner newResourceProvisioner(HostRegistry hr) throws RuntimeException {
        return PolicyLoader.resourceProvisioner("", hr.getBwProvisioner());
    }

    public static PeProvisioner newPeProvisioner(HostRegistry hr) throws RuntimeException {
        return (PeProvisioner)PolicyLoader.resourceProvisioner("Pe", hr.getPeProvisioner());
    }

    public static VmAllocationPolicy vmAllocationPolicy(DatacenterRegistry dcr) throws RuntimeException {
        try {
            String className = PolicyLoader.generateFullClassName("org.cloudsimplus.allocationpolicies", "VmAllocationPolicy", dcr.getVmAllocationPolicy());
            Class klass = PolicyLoader.loadClass(className);
            Constructor constructor = klass.getConstructor(new Class[0]);
            return (VmAllocationPolicy)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static CloudletScheduler cloudletScheduler(VmRegistry vmr) throws RuntimeException {
        try {
            String className = PolicyLoader.generateFullClassName("org.cloudsimplus.schedulers.cloudlet", "CloudletScheduler", vmr.getCloudletScheduler());
            Class klass = PolicyLoader.loadClass(className);
            Constructor constructor = klass.getConstructor(new Class[0]);
            return (CloudletScheduler)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private static String generateFullClassName(String packageName, String classPrefix, String classSuffix) {
        return String.format("%s.%s%s", packageName, classPrefix, classSuffix);
    }

    private static String generateFullProvisionerClassName(String classPrefix, String classSuffix) {
        classPrefix = ((String)classPrefix).isEmpty() ? "ResourceProvisioner" : (String)classPrefix + "Provisioner";
        return PolicyLoader.generateFullClassName("org.cloudsimplus.provisioners", (String)classPrefix, classSuffix);
    }

    public static UtilizationModel utilizationModel(String classSuffix) throws RuntimeException {
        try {
            String className = PolicyLoader.generateFullClassName("org.cloudsimplus.utilizationmodels", "UtilizationModel", classSuffix);
            Class klass = PolicyLoader.loadClass(className);
            Constructor constructor = klass.getConstructor(new Class[0]);
            return (UtilizationModel)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PolicyLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

