/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.automation;

import ch.qos.logback.classic.Level;
import cloudreports.models.CloudletRegistry;
import cloudreports.models.CustomerRegistry;
import cloudreports.models.DatacenterRegistry;
import cloudreports.models.HostRegistry;
import cloudreports.models.SanStorageRegistry;
import cloudreports.models.VmRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.automation.LogUtils;
import org.cloudsimplus.automation.PolicyLoader;
import org.cloudsimplus.automation.YamlCloudScenario;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.builders.tables.CloudletsTableBuilder;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.cloudlets.CloudletSimple;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.Identifiable;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterSimple;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostSimple;
import org.cloudsimplus.provisioners.ResourceProvisioner;
import org.cloudsimplus.resources.DatacenterStorage;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.PeSimple;
import org.cloudsimplus.resources.SanStorage;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.schedulers.vm.VmScheduler;
import org.cloudsimplus.util.Log;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class CloudSimulation
implements Runnable {
    private final YamlCloudScenario scenario;
    private CloudSimPlus cloudsimplus;
    private List<Datacenter> datacenters;
    private boolean showResults;
    private boolean logEnabled;
    private boolean printScenariosConfiguration;
    private Map<DatacenterBroker, CustomerRegistry> brokers;
    private Map<DatacenterBroker, List<Vm>> vmsToBrokerMap;
    private Map<DatacenterBroker, List<Cloudlet>> cloudletsToBrokerMap;

    public CloudSimulation(YamlCloudScenario scenario) {
        this(scenario, "");
    }

    public CloudSimulation(YamlCloudScenario scenario, String label) {
        this.scenario = scenario;
        this.showResults = true;
        this.printScenariosConfiguration = true;
        this.datacenters = new ArrayList<Datacenter>();
        this.logEnabled = false;
        this.brokers = new HashMap<DatacenterBroker, CustomerRegistry>();
        this.vmsToBrokerMap = new HashMap<DatacenterBroker, List<Vm>>();
        this.cloudletsToBrokerMap = new HashMap<DatacenterBroker, List<Cloudlet>>();
    }

    private Map<DatacenterBroker, CustomerRegistry> createBrokers() {
        int totalBrokerAmount = this.scenario.getCustomers().stream().mapToInt(CustomerRegistry::getAmount).sum();
        HashMap<DatacenterBroker, CustomerRegistry> map = new HashMap<DatacenterBroker, CustomerRegistry>(totalBrokerAmount);
        for (CustomerRegistry cr : this.scenario.getCustomers()) {
            for (int i = 0; i < cr.getAmount(); ++i) {
                map.put((DatacenterBroker)new DatacenterBrokerSimple(this.cloudsimplus), cr);
            }
        }
        return map;
    }

    private Map<DatacenterBroker, List<Vm>> createVmListForAllBrokers(Map<DatacenterBroker, CustomerRegistry> crMap) {
        HashMap<DatacenterBroker, List<Vm>> vmMap = new HashMap<DatacenterBroker, List<Vm>>(crMap.size());
        int createdVms = 0;
        for (DatacenterBroker broker : crMap.keySet()) {
            List<Vm> vmList = this.createVmListForOneBroker(broker, crMap.get(broker), createdVms++);
            vmMap.put(broker, vmList);
        }
        return vmMap;
    }

    private List<Vm> createVmListForOneBroker(DatacenterBroker broker, CustomerRegistry cr, int createdVms) throws RuntimeException {
        int totalVmsAmount = cr.getVms().stream().mapToInt(VmRegistry::getAmount).sum();
        ArrayList<Vm> vmList = new ArrayList<Vm>(totalVmsAmount);
        for (VmRegistry vmr : cr.getVms()) {
            for (int i = 0; i < vmr.getAmount(); ++i) {
                vmList.add(this.createVm(createdVms + i, broker, vmr));
            }
        }
        return vmList;
    }

    private Vm createVm(int id, DatacenterBroker broker, VmRegistry vmr) throws RuntimeException {
        CloudletScheduler scheduler = PolicyLoader.cloudletScheduler(vmr);
        VmSimple vm = new VmSimple((long)id, vmr.getMips(), (long)vmr.getPes());
        vm.setRam((long)vmr.getRam()).setBw(vmr.getBw()).setSize(vmr.getSize()).setCloudletScheduler(scheduler).setBroker(broker);
        return vm;
    }

    private Map<DatacenterBroker, List<Cloudlet>> createCloudlets(Map<DatacenterBroker, CustomerRegistry> brokerRegistries) {
        HashMap<DatacenterBroker, List<Cloudlet>> map = new HashMap<DatacenterBroker, List<Cloudlet>>(brokerRegistries.size());
        int createdCloudlets = 0;
        for (DatacenterBroker broker : brokerRegistries.keySet()) {
            int cloudletsNum = brokerRegistries.get(broker).getCloudlets().stream().mapToInt(CloudletRegistry::getAmount).sum();
            ArrayList<Cloudlet> cloudletList = new ArrayList<Cloudlet>(cloudletsNum);
            for (CloudletRegistry up : brokerRegistries.get(broker).getCloudlets()) {
                for (int i = 0; i < up.getAmount(); ++i) {
                    cloudletList.add(this.createCloudlet(++createdCloudlets, up, broker));
                }
            }
            map.put(broker, cloudletList);
        }
        return map;
    }

    private Cloudlet createCloudlet(int id, CloudletRegistry up, DatacenterBroker broker) throws RuntimeException {
        UtilizationModel cpuUtilization = PolicyLoader.utilizationModel(up.getUtilizationModelCpu());
        UtilizationModel ramUtilization = PolicyLoader.utilizationModel(up.getUtilizationModelRam());
        UtilizationModel bwUtilization = PolicyLoader.utilizationModel(up.getUtilizationModelBw());
        CloudletSimple cloudlet = new CloudletSimple((long)id, up.getLength(), (long)up.getPes());
        cloudlet.setFileSize(up.getFileSize()).setOutputSize(up.getOutputSize()).setUtilizationModelCpu(cpuUtilization).setUtilizationModelRam(ramUtilization).setUtilizationModelBw(bwUtilization).setBroker(broker);
        return cloudlet;
    }

    private Vm findVm(DatacenterBroker broker, int vmId) {
        return this.vmsToBrokerMap.get(broker).stream().filter(vm -> vm.getId() == (long)vmId).findFirst().orElse(Vm.NULL);
    }

    private List<Datacenter> createDatacenters() throws IllegalArgumentException {
        int datacenterCount = 0;
        int datacenterNumber = this.scenario.getDatacenters().stream().mapToInt(DatacenterRegistry::getAmount).sum();
        ArrayList<Datacenter> datacenterList = new ArrayList<Datacenter>(datacenterNumber);
        for (DatacenterRegistry dcr : this.scenario.getDatacenters()) {
            int hostCount = 0;
            for (int i = 0; i < dcr.getAmount(); ++i) {
                String datacenterName = this.generateDataCenterName(dcr, ++datacenterCount);
                List<Host> hostList = this.createHosts(dcr, hostCount);
                hostCount += hostList.size();
                try {
                    Datacenter dc = this.createDataCenter(datacenterName, dcr, hostList);
                    datacenterList.add(dc);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return datacenterList;
    }

    private List<Host> createHosts(DatacenterRegistry dcr, int initialHostId) throws RuntimeException {
        int hostNumber = dcr.getHosts().stream().mapToInt(HostRegistry::getAmount).sum();
        ArrayList<Host> hostList = new ArrayList<Host>(hostNumber);
        for (HostRegistry hr : dcr.getHosts()) {
            for (int i = 0; i < hr.getAmount(); ++i) {
                List<Pe> peList = this.createHostProcessingElements(hr);
                int hostId = this.generateHostId(hr, ++initialHostId);
                hostList.add(this.createHost(hostId, hr, peList));
            }
        }
        return hostList;
    }

    private String generateDataCenterName(DatacenterRegistry dcr, int datacenterCount) {
        String datacenterName = dcr.getName();
        if (dcr.getName() == null || dcr.getName().trim().equals("")) {
            return String.format("datacenter%d", datacenterCount);
        }
        return datacenterName;
    }

    private Datacenter createDataCenter(String datacenterName, DatacenterRegistry dcr, List<Host> hostList) {
        List<SanStorage> storageList = this.createSan(dcr);
        VmAllocationPolicy allocationPolicy = PolicyLoader.vmAllocationPolicy(dcr);
        DatacenterSimple dc = new DatacenterSimple((Simulation)this.cloudsimplus, hostList, allocationPolicy);
        dc.setSchedulingInterval(dcr.getSchedulingInterval()).setDatacenterStorage(new DatacenterStorage(storageList));
        this.setDatacenterCharacteristics((Datacenter)dc, dcr);
        return dc;
    }

    private Host createHost(int hostId, HostRegistry hr, List<Pe> peList) throws RuntimeException {
        ResourceProvisioner ramProvisioner = PolicyLoader.newResourceProvisioner(hr);
        ResourceProvisioner bwProvisioner = PolicyLoader.newResourceProvisioner(hr);
        VmScheduler vmScheduler = PolicyLoader.vmScheduler(hr.getVmScheduler());
        HostSimple host = new HostSimple((long)hr.getRam(), hr.getBw(), hr.getStorage(), peList);
        host.setRamProvisioner(ramProvisioner).setBwProvisioner(bwProvisioner).setVmScheduler(vmScheduler).setId((long)hostId);
        return host;
    }

    private int generateHostId(HostRegistry hr, int currentHostCount) {
        return hr.getId() != 0 ? hr.getId() : currentHostCount;
    }

    private List<SanStorage> createSan(DatacenterRegistry dcr) throws IllegalArgumentException {
        ArrayList<SanStorage> storageList = new ArrayList<SanStorage>(dcr.getSans().size());
        for (SanStorageRegistry sr : dcr.getSans()) {
            SanStorage san = new SanStorage(sr.getCapacity(), sr.getBandwidth(), sr.getNetworkLatency());
            storageList.add(san);
        }
        return storageList;
    }

    private void setDatacenterCharacteristics(Datacenter dc, DatacenterRegistry dcr) {
        dc.getCharacteristics().setArchitecture(dcr.getArchitecture()).setOs(dcr.getOs()).setVmm(dcr.getVmm()).setCostPerSecond(dcr.getCostPerSec()).setCostPerMem(dcr.getCostPerMem()).setCostPerStorage(dcr.getCostPerStorage()).setCostPerBw(dcr.getCostPerBw());
    }

    private List<Pe> createHostProcessingElements(HostRegistry hr) {
        ArrayList<Pe> peList = new ArrayList<Pe>(hr.getPes());
        for (int i = 0; i < hr.getPes(); ++i) {
            peList.add((Pe)new PeSimple(hr.getMips(), PolicyLoader.newPeProvisioner(hr)));
        }
        return peList;
    }

    @Override
    public void run() {
        double startTime = System.currentTimeMillis();
        this.cloudsimplus = new CloudSimPlus();
        if (!this.logEnabled) {
            Log.setLevel((Level)Level.OFF);
        }
        this.datacenters = this.createDatacenters();
        this.printScenariosConfiguration();
        this.brokers = this.createBrokers();
        this.vmsToBrokerMap = this.createVmListForAllBrokers(this.brokers);
        this.cloudletsToBrokerMap = this.createCloudlets(this.brokers);
        for (DatacenterBroker broker : this.brokers.keySet()) {
            broker.submitVmList(this.vmsToBrokerMap.get(broker));
            broker.submitCloudletList(this.cloudletsToBrokerMap.get(broker));
        }
        this.cloudsimplus.start();
        if (this.showResults) {
            for (DatacenterBroker broker : this.brokers.keySet()) {
                List cloudletList = broker.getCloudletFinishedList();
                cloudletList.sort(Comparator.comparingLong(c -> c.getVm().getId()).thenComparingLong(Identifiable::getId));
                new CloudletsTableBuilder(cloudletList).setTitle(broker.getName()).build();
            }
        }
        double finishTimeSecs = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println();
        this.printFinalResults(finishTimeSecs);
    }

    private void printScenariosConfiguration() {
        if (!this.isPrintScenariosConfiguration()) {
            return;
        }
        System.out.println("Hosts========================");
        for (Datacenter datacenter : this.datacenters) {
            System.out.println(datacenter.getName() + ": " + datacenter.getHostList().size() + " hosts");
        }
        System.out.println("=============================");
    }

    private void printFinalResults(double finishTimeSecs) {
        LogUtils.setColSeparator(";");
        String[] captions = new String[]{"Framework    ", "Simulation time (seconds)", "Simulation time (minutes)", "Simulation time (hours)", "Datacenters", "Hosts from all DCs", "VMs from all Customers", "Cloudlets from all Customers"};
        LogUtils.printCaptions(captions);
        LogUtils.printLine(captions, "CloudSim Plus", finishTimeSecs, String.format("%.4f", finishTimeSecs / 60.0), String.format("%.6f", finishTimeSecs / 3600.0), this.getNumDatacenters(), this.getNumHostsFromAllDatacenters(), this.getNumVmsFromAllCustomers(), this.getNumCloudletsFromAllCustomers());
    }

    private int getNumDatacenters() {
        return this.scenario.getDatacenters().stream().mapToInt(DatacenterRegistry::getAmount).sum();
    }

    private int getNumHostsFromAllDatacenters() {
        return this.scenario.getDatacenters().stream().mapToInt(dc -> dc.getAmount() * this.getNumOfHostsFromDatacenter((DatacenterRegistry)dc)).sum();
    }

    private int getNumOfHostsFromDatacenter(DatacenterRegistry dc) {
        return dc.getHosts().stream().mapToInt(h -> h.getAmount()).sum();
    }

    private int getNumVmsFromAllCustomers() {
        return this.scenario.getCustomers().stream().mapToInt(c -> c.getAmount() * this.getNumVmsForCustomer((CustomerRegistry)c)).sum();
    }

    private int getNumVmsForCustomer(CustomerRegistry customer) {
        return customer.getVms().stream().mapToInt(vm -> vm.getAmount()).sum();
    }

    private int getNumCloudletsFromAllCustomers() {
        return this.scenario.getCustomers().stream().mapToInt(c -> c.getAmount() * this.getNumCloudletsForCustomer((CustomerRegistry)c)).sum();
    }

    private int getNumCloudletsForCustomer(CustomerRegistry customer) {
        return customer.getCloudlets().stream().mapToInt(cloudlet -> cloudlet.getAmount()).sum();
    }

    public CloudSimPlus getCloudSimPlus() {
        return this.cloudsimplus;
    }

    public List<Datacenter> getDatacenters() {
        return this.datacenters;
    }

    public List<Host> getHosts() {
        return this.datacenters.stream().map(Datacenter::getHostList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<DatacenterBroker> getBrokers() {
        return new ArrayList<DatacenterBroker>(this.brokers.keySet());
    }

    public List<Vm> getVms(DatacenterBroker broker) {
        return this.vmsToBrokerMap.get(broker);
    }

    public List<Vm> getVms() {
        return this.vmsToBrokerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Cloudlet> getCloudlets(DatacenterBroker broker) {
        return this.cloudletsToBrokerMap.get(broker);
    }

    public List<Cloudlet> getCloudlets() {
        return this.cloudletsToBrokerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isShowResults() {
        return this.showResults;
    }

    public CloudSimulation setShowResults(boolean showResults) {
        this.showResults = showResults;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public CloudSimulation setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public boolean isPrintScenariosConfiguration() {
        return this.printScenariosConfiguration;
    }

    public CloudSimulation setPrintScenariosConfiguration(boolean printScenariosConfiguration) {
        this.printScenariosConfiguration = printScenariosConfiguration;
        return this;
    }
}

