/*
 * Decompiled with CFR 0.152.
 */
package cloudreports.models;

import java.io.Serializable;

public final class VmRegistry
implements Serializable {
    private long id;
    private long size;
    private int pes;
    private double mips;
    private int ram;
    private long bw;
    private int priority;
    private String vmm;
    private String cloudletScheduler;
    private int amount;

    public VmRegistry() {
        this.setAmount(1);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getPes() {
        return this.pes;
    }

    public void setPes(int pes) {
        this.pes = pes;
    }

    public double getMips() {
        return this.mips;
    }

    public void setMips(double mips) {
        this.mips = mips;
    }

    public int getRam() {
        return this.ram;
    }

    public void setRam(int ram) {
        this.ram = ram;
    }

    public long getBw() {
        return this.bw;
    }

    public void setBw(long bw) {
        this.bw = bw;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getVmm() {
        return this.vmm;
    }

    public void setVmm(String vmm) {
        this.vmm = vmm;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getCloudletScheduler() {
        return this.cloudletScheduler;
    }

    public void setCloudletScheduler(String cloudletScheduler) {
        this.cloudletScheduler = cloudletScheduler;
    }

    public boolean equals(Object virtualMachine) {
        if (this == virtualMachine) {
            return true;
        }
        if (!(virtualMachine instanceof VmRegistry)) {
            return false;
        }
        VmRegistry vr = (VmRegistry)virtualMachine;
        return this.getId() == vr.getId();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("VM Id=" + this.getId() + "\n");
        s.append("Number of VMs=" + this.getAmount() + "\n");
        s.append("Image size=" + this.getSize() + "\n");
        s.append("VM processors=" + this.getPes() + "\n");
        s.append("VM MIPS=" + this.getMips() + "\n");
        s.append("VM RAM=" + this.getRam() + "\n");
        s.append("VM Bandwidth=" + this.getBw() + "\n");
        s.append("VM Priority=" + this.getPriority() + "\n");
        if (this.getVmm().equalsIgnoreCase("xen")) {
            s.append("Hypervisor=xen\n");
        } else {
            s.append("Hypervisor=kvm\n");
        }
        return s.toString();
    }
}

