/*
 * Decompiled with CFR 0.152.
 */
package cloudreports.models;

import cloudreports.models.VmRegistry;
import java.io.Serializable;

public final class HostRegistry
implements Serializable {
    private int id;
    private int pes;
    private double mips;
    private double maxPower;
    private double staticPowerPercent;
    private int ram;
    private long bw;
    private String ramProvisioner;
    private String bwProvisioner;
    private String peProvisioner;
    private String vmScheduler;
    private String powerModel;
    private int amount;
    private long storage;

    public HostRegistry() {
        this.setAmount(1);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getVmScheduler() {
        return this.vmScheduler;
    }

    public void setVmScheduler(String vmScheduler) {
        this.vmScheduler = vmScheduler;
    }

    public int getPes() {
        return this.pes;
    }

    public void setPes(int numOfpes) {
        this.pes = numOfpes;
    }

    public double getMips() {
        return this.mips;
    }

    public void setMips(double mips) {
        this.mips = mips;
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(double maxPower) {
        this.maxPower = maxPower;
    }

    public double getStaticPowerPercent() {
        return this.staticPowerPercent;
    }

    public void setStaticPowerPercent(double staticPowerPercent) {
        this.staticPowerPercent = staticPowerPercent;
    }

    public String getPowerModel() {
        return this.powerModel;
    }

    public void setPowerModel(String powerModel) {
        this.powerModel = powerModel;
    }

    public int getRam() {
        return this.ram;
    }

    public void setRam(int ram) {
        this.ram = ram;
    }

    public long getBw() {
        return this.bw;
    }

    public void setBw(long bw) {
        this.bw = bw;
    }

    public String getRamProvisioner() {
        return this.ramProvisioner;
    }

    public void setRamProvisioner(String ramProvisioner) {
        this.ramProvisioner = ramProvisioner;
    }

    public String getBwProvisioner() {
        return this.bwProvisioner;
    }

    public void setBwProvisioner(String bwProvisioner) {
        this.bwProvisioner = bwProvisioner;
    }

    public String getPeProvisioner() {
        return this.peProvisioner;
    }

    public void setPeProvisioner(String peProvisioner) {
        this.peProvisioner = peProvisioner;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public long getStorage() {
        return this.storage;
    }

    public void setStorage(long storage) {
        this.storage = storage;
    }

    public boolean canRunVM(VmRegistry vmr) {
        if (this.getRam() < vmr.getRam()) {
            return false;
        }
        if ((double)this.getPes() * this.getMips() < vmr.getMips()) {
            return false;
        }
        if (this.getBw() < vmr.getBw()) {
            return false;
        }
        return this.getStorage() >= vmr.getSize();
    }

    public boolean equals(Object host) {
        if (this == host) {
            return true;
        }
        if (!(host instanceof HostRegistry)) {
            return false;
        }
        HostRegistry hr = (HostRegistry)host;
        return this.getId() == hr.getId();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.id ^ this.id >>> 32);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Host Id=" + this.getId() + "\n");
        s.append("Amount=" + this.getAmount() + "\n");
        s.append("VM Scheduling =" + this.getVmScheduler() + "\n");
        s.append("Processing Elements=" + this.getPes() + "\n");
        s.append("MIPS/PE=" + this.getMips() + "\n");
        s.append("PE Provisioner =" + this.getPeProvisioner() + "\n");
        s.append("Maximum Power=" + this.getMaxPower() + "\n");
        s.append("Static Power Percent=" + this.getStaticPowerPercent() + "\n");
        s.append("Power Model =" + this.getPowerModel() + "\n");
        s.append("RAM=" + this.getRam() + "\n");
        s.append("RAM Provisioner =" + this.getRamProvisioner() + "\n");
        s.append("Bandwidth=" + this.getBw() + "\n");
        s.append("Bandwidth Provisioner =" + this.getBwProvisioner() + "\n");
        s.append("Storage=" + this.getStorage() + "\n");
        return s.toString();
    }
}

