/*
 * Decompiled with CFR 0.152.
 */
package cloudreports.models;

import cloudreports.models.HostRegistry;
import cloudreports.models.SanStorageRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DatacenterRegistry
implements Serializable {
    private long id;
    private String name;
    private Integer amount;
    private String architecture;
    private String os;
    private String vmm;
    private double timeZone;
    private String vmAllocationPolicy;
    private boolean vmMigration;
    private List<HostRegistry> hosts;
    private double costPerSec;
    private double costPerMem;
    private double costPerStorage;
    private double costPerBw;
    private List<SanStorageRegistry> sans;
    private double upperUtilizationThreshold;
    private double lowerUtilizationThreshold;
    private double schedulingInterval;

    public DatacenterRegistry() {
        this.setAmount(1);
        this.sans = new ArrayList<SanStorageRegistry>();
        this.hosts = new ArrayList<HostRegistry>();
        this.setArchitecture("x86");
        this.setOs("Linux");
        this.setVmm("Xen");
        this.setSchedulingInterval(0.0);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getVmm() {
        return this.vmm;
    }

    public void setVmm(String vmm) {
        this.vmm = vmm;
    }

    public double getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(double timeZone) {
        this.timeZone = timeZone;
    }

    public String getVmAllocationPolicy() {
        return this.vmAllocationPolicy;
    }

    public void setVmAllocationPolicy(String vmAllocationPolicy) {
        this.vmAllocationPolicy = vmAllocationPolicy;
    }

    public boolean isVmMigration() {
        return this.vmMigration;
    }

    public void setVmMigration(boolean vmMigration) {
        this.vmMigration = vmMigration;
    }

    public List<HostRegistry> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<HostRegistry> hosts) {
        this.hosts = hosts;
    }

    public double getCostPerSec() {
        return this.costPerSec;
    }

    public void setCostPerSec(double costPerSec) {
        this.costPerSec = costPerSec;
    }

    public double getCostPerMem() {
        return this.costPerMem;
    }

    public void setCostPerMem(double costPerMem) {
        this.costPerMem = costPerMem;
    }

    public double getCostPerStorage() {
        return this.costPerStorage;
    }

    public void setCostPerStorage(double costPerStorage) {
        this.costPerStorage = costPerStorage;
    }

    public double getCostPerBw() {
        return this.costPerBw;
    }

    public void setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
    }

    public List<SanStorageRegistry> getSans() {
        return this.sans;
    }

    public void setSans(List<SanStorageRegistry> sans) {
        this.sans = sans;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public void setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
    }

    public double getUpperUtilizationThreshold() {
        return this.upperUtilizationThreshold;
    }

    public void setUpperUtilizationThreshold(double upperUtilizationThreshold) {
        this.upperUtilizationThreshold = upperUtilizationThreshold;
    }

    public double getLowerUtilizationThreshold() {
        return this.lowerUtilizationThreshold;
    }

    public void setLowerUtilizationThreshold(double lowerUtilizationThreshold) {
        this.lowerUtilizationThreshold = lowerUtilizationThreshold;
    }

    public boolean equals(Object datacenter) {
        if (this == datacenter) {
            return true;
        }
        if (!(datacenter instanceof DatacenterRegistry)) {
            return false;
        }
        DatacenterRegistry dr = (DatacenterRegistry)datacenter;
        return this.getName().equals(dr.getName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Name=" + this.getName() + "\n");
        s.append("Architecture=").append(this.getArchitecture()).append("\n");
        s.append("Operating System=").append(this.getOs()).append("\n");
        s.append("Hypervisor=").append(this.getVmm()).append("\n");
        s.append("Allocation Policy ID=").append(this.getVmAllocationPolicy()).append("\n");
        s.append("Time Zone (GMT)=").append(this.getTimeZone()).append("\n");
        s.append("VM Migrations=").append(this.isVmMigration()).append("\n");
        s.append("Upper Utilization threshold=").append(this.getUpperUtilizationThreshold()).append("\n");
        s.append("Lower Utilization threshold=").append(this.getLowerUtilizationThreshold()).append("\n");
        s.append("Scheduling interval=").append(this.getSchedulingInterval()).append("\n");
        s.append("Processing Cost=").append(this.getCostPerSec()).append("\n");
        s.append("Memory Cost=").append(this.getCostPerMem()).append("\n");
        s.append("Storage Cost=").append(this.getCostPerStorage()).append("\n");
        s.append("Bandwidth Cost=").append(this.getCostPerBw()).append("\n");
        s.append("\n++Beginning of hosts list++\n");
        for (HostRegistry hr : this.getHosts()) {
            s.append("\n").append(hr.toString());
        }
        s.append("\n++End of hosts list++\n");
        s.append("\n++Beginning of SAN list++\n");
        for (SanStorageRegistry sr : this.getSans()) {
            s.append("\n").append(sr.toString());
        }
        s.append("\n++End of SAN list++\n");
        return s.toString();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }
}

