/*
 * Decompiled with CFR 0.152.
 */
package cloudreports.models;

import cloudreports.models.CloudletRegistry;
import cloudreports.models.VmRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class CustomerRegistry
implements Serializable {
    private long id;
    private String name;
    private Integer amount;
    private List<VmRegistry> vms = new ArrayList<VmRegistry>();
    private List<CloudletRegistry> cloudlets = new ArrayList<CloudletRegistry>();

    public CustomerRegistry() {
        this.setAmount(1);
    }

    public CustomerRegistry(String name) {
        this();
        this.name = name;
        this.vms = new LinkedList<VmRegistry>();
        this.vms.add(new VmRegistry());
        this.cloudlets = new LinkedList<CloudletRegistry>();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<VmRegistry> getVms() {
        return this.vms;
    }

    public void setVms(List<VmRegistry> vms) {
        this.vms = vms;
    }

    public List<CloudletRegistry> getCloudlets() {
        return this.cloudlets;
    }

    public void setCloudlets(List<CloudletRegistry> cloudlets) {
        this.cloudlets = cloudlets;
    }

    public boolean equals(Object customer) {
        if (this == customer) {
            return true;
        }
        if (!(customer instanceof CustomerRegistry)) {
            return false;
        }
        CustomerRegistry cr = (CustomerRegistry)customer;
        return this.getName().equals(cr.getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Name=" + this.getName() + "\n");
        s.append("\n++List of Virtual Machines per user from this customer++\n");
        for (VmRegistry vmr : this.getVms()) {
            s.append("\n" + vmr.toString());
        }
        s.append("\n++End of virtual machines description++\n");
        s.append("\n++Utilization profile of this costumer++\n");
        s.append(this.getCloudlets().toString());
        s.append("\n++End of utilization profile description++\n");
        return s.toString();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }
}

