/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms.network;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.network.NetworkCloudlet;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.VmPacket;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class NetworkVm
extends VmSimple {
    public static final NetworkVm NULL = new NetworkVm();
    @NonNull
    private List<NetworkCloudlet> cloudletList = new ArrayList<NetworkCloudlet>();
    @NonNull
    private List<VmPacket> receivedPacketList;
    private boolean free;
    private double finishTime;

    public NetworkVm(int id, long mipsCapacity, int pesNumber) {
        super((long)id, mipsCapacity, (long)pesNumber);
    }

    private NetworkVm() {
        this(-1, 0L, 1);
    }

    public NetworkVm(long mipsCapacity, int pesNumber) {
        super(mipsCapacity, pesNumber);
    }

    @Override
    public NetworkHost getHost() {
        return (NetworkHost)super.getHost();
    }

    @Override
    public Vm setHost(Host host) {
        if (host == Host.NULL) {
            return super.setHost(NetworkHost.NULL);
        }
        if (host instanceof NetworkHost) {
            return super.setHost(host);
        }
        throw new IllegalArgumentException("NetworkVm can only be run into a NetworkHost");
    }

    @NonNull
    public final List<NetworkCloudlet> getCloudletList() {
        return this.cloudletList;
    }

    @NonNull
    public final List<VmPacket> getReceivedPacketList() {
        return this.receivedPacketList;
    }

    public final boolean isFree() {
        return this.free;
    }

    public final double getFinishTime() {
        return this.finishTime;
    }

    public final NetworkVm setCloudletList(@NonNull List<NetworkCloudlet> cloudletList) {
        if (cloudletList == null) {
            throw new NullPointerException("cloudletList is marked non-null but is null");
        }
        this.cloudletList = cloudletList;
        return this;
    }

    public final NetworkVm setReceivedPacketList(@NonNull List<VmPacket> receivedPacketList) {
        if (receivedPacketList == null) {
            throw new NullPointerException("receivedPacketList is marked non-null but is null");
        }
        this.receivedPacketList = receivedPacketList;
        return this;
    }

    public final NetworkVm setFree(boolean free) {
        this.free = free;
        return this;
    }

    public final NetworkVm setFinishTime(double finishTime) {
        this.finishTime = finishTime;
        return this;
    }
}

