/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

public class VmStateHistoryEntry {
    private double time;
    private double allocatedMips;
    private double requestedMips;
    private boolean inMigration;

    public VmStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean inMigration) {
        this.setTime(time);
        this.setAllocatedMips(allocatedMips);
        this.setRequestedMips(requestedMips);
        this.setInMigration(inMigration);
    }

    protected final void setTime(double time) {
        this.time = time;
    }

    protected final void setAllocatedMips(double allocatedMips) {
        this.allocatedMips = allocatedMips;
    }

    protected final void setRequestedMips(double requestedMips) {
        this.requestedMips = requestedMips;
    }

    protected final void setInMigration(boolean inMigration) {
        this.inMigration = inMigration;
    }

    public final double getTime() {
        return this.time;
    }

    public final double getAllocatedMips() {
        return this.allocatedMips;
    }

    public final double getRequestedMips() {
        return this.requestedMips;
    }

    public final boolean isInMigration() {
        return this.inMigration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStateHistoryEntry)) {
            return false;
        }
        VmStateHistoryEntry other = (VmStateHistoryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTime(), other.getTime()) != 0) {
            return false;
        }
        if (Double.compare(this.getAllocatedMips(), other.getAllocatedMips()) != 0) {
            return false;
        }
        if (Double.compare(this.getRequestedMips(), other.getRequestedMips()) != 0) {
            return false;
        }
        return this.isInMigration() == other.isInMigration();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStateHistoryEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = Double.doubleToLongBits(this.getTime());
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $allocatedMips = Double.doubleToLongBits(this.getAllocatedMips());
        result = result * 59 + (int)($allocatedMips >>> 32 ^ $allocatedMips);
        long $requestedMips = Double.doubleToLongBits(this.getRequestedMips());
        result = result * 59 + (int)($requestedMips >>> 32 ^ $requestedMips);
        result = result * 59 + (this.isInMigration() ? 79 : 97);
        return result;
    }
}

