/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.AbstractMachine;
import org.cloudsimplus.core.CustomerEntityAbstract;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;
import org.cloudsimplus.resources.Bandwidth;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.Processor;
import org.cloudsimplus.resources.Ram;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.resources.SimpleStorage;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.schedulers.cloudlet.CloudletSchedulerTimeShared;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmGroup;
import org.cloudsimplus.vms.VmResourceStats;
import org.cloudsimplus.vms.VmStateHistoryEntry;

public class VmSimple
extends CustomerEntityAbstract
implements Vm {
    private static long defaultRamCapacity = 1024L;
    private static long defaultBwCapacity = 100L;
    private static long defaultStorageCapacity = 1024L;
    private String description;
    private String vmm;
    private Host host;
    private double timeZone;
    private double submissionDelay;
    private double startTime;
    private double stopTime;
    private double lastBusyTime;
    @NonNull
    private VmGroup group;
    private boolean failed;
    private SimpleStorage storage;
    private Ram ram;
    private Bandwidth bw;
    private final Processor processor;
    @NonNull
    private CloudletScheduler cloudletScheduler;
    private boolean created;
    private boolean inMigration;
    private List<ResourceManageable> resources;
    private long freePesNumber;
    private long expectedFreePesNumber;
    private HorizontalVmScaling horizontalScaling;
    private VerticalVmScaling ramVerticalScaling;
    private VerticalVmScaling bwVerticalScaling;
    private VerticalVmScaling peVerticalScaling;
    @NonNull
    private MipsShare allocatedMips;
    @NonNull
    private MipsShare requestedMips;
    private VmResourceStats cpuUtilizationStats;
    private final List<VmStateHistoryEntry> stateHistory;
    private final List<EventListener<VmHostEventInfo>> onMigrationStartListeners;
    private final List<EventListener<VmHostEventInfo>> onMigrationFinishListeners;
    private final List<EventListener<VmHostEventInfo>> onHostAllocationListeners;
    private final List<EventListener<VmHostEventInfo>> onHostDeallocationListeners;
    private final List<EventListener<VmHostEventInfo>> onUpdateProcessingListeners;
    private final List<EventListener<VmDatacenterEventInfo>> onCreationFailureListeners;

    public VmSimple(Vm sourceVm) {
        this(sourceVm.getMips(), sourceVm.getPesNumber());
        this.setBw(sourceVm.getBw().getCapacity()).setRam(sourceVm.getRam().getCapacity()).setSize(sourceVm.getStorage().getCapacity());
    }

    public VmSimple(double mipsCapacity, long pesNumber) {
        this(-1L, mipsCapacity, pesNumber);
    }

    public VmSimple(double mipsCapacity, long pesNumber, CloudletScheduler cloudletScheduler) {
        this(-1L, mipsCapacity, pesNumber);
        this.setCloudletScheduler(cloudletScheduler);
    }

    public VmSimple(long id, double mipsCapacity, long pesNumber) {
        this(id, (long)mipsCapacity, pesNumber);
    }

    public VmSimple(long id, long mipsCapacity, long pesNumber) {
        this.setId(id);
        this.resources = new ArrayList<ResourceManageable>(4);
        this.onMigrationStartListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onMigrationFinishListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onHostAllocationListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onHostDeallocationListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onCreationFailureListeners = new ArrayList<EventListener<VmDatacenterEventInfo>>();
        this.onUpdateProcessingListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.stateHistory = new LinkedList<VmStateHistoryEntry>();
        this.allocatedMips = new MipsShare();
        this.requestedMips = new MipsShare();
        this.processor = new Processor(this, pesNumber, mipsCapacity);
        this.setMips(mipsCapacity);
        this.setPesNumber(pesNumber);
        this.mutableAttributesInit();
        this.freePesNumber = pesNumber;
        this.expectedFreePesNumber = pesNumber;
    }

    private void mutableAttributesInit() {
        this.description = "";
        this.startTime = -1.0;
        this.stopTime = -1.0;
        this.lastBusyTime = Double.MAX_VALUE;
        this.setBroker(DatacenterBroker.NULL);
        this.setSubmissionDelay(0.0);
        this.setVmm("Xen");
        this.setInMigration(false);
        this.host = Host.NULL;
        this.setCloudletScheduler(new CloudletSchedulerTimeShared());
        this.setHorizontalScaling(HorizontalVmScaling.NULL);
        this.setRamVerticalScaling(VerticalVmScaling.NULL);
        this.setBwVerticalScaling(VerticalVmScaling.NULL);
        this.setPeVerticalScaling(VerticalVmScaling.NULL);
        this.cpuUtilizationStats = VmResourceStats.NULL;
        this.setRam(new Ram(defaultRamCapacity));
        this.setBw(new Bandwidth(defaultBwCapacity));
        this.setStorage(new SimpleStorage(defaultStorageCapacity));
    }

    @Override
    public double updateProcessing(MipsShare mipsShare) {
        return this.updateProcessing(this.getSimulation().clock(), mipsShare);
    }

    @Override
    public double updateProcessing(double currentTime, MipsShare mipsShare) {
        Objects.requireNonNull(mipsShare);
        if (!this.cloudletScheduler.isEmpty()) {
            this.setLastBusyTime();
        }
        double nextSimulationDelay = this.cloudletScheduler.updateProcessing(currentTime, mipsShare);
        this.notifyOnUpdateProcessingListeners();
        this.cpuUtilizationStats.add(currentTime);
        this.getBroker().requestIdleVmDestruction(this);
        if (nextSimulationDelay == Double.MAX_VALUE) {
            return nextSimulationDelay;
        }
        double decimals = currentTime - (double)((int)currentTime);
        return nextSimulationDelay - decimals < 0.0 ? nextSimulationDelay : nextSimulationDelay - decimals;
    }

    public Vm setFreePesNumber(long freePesNumber) {
        if (freePesNumber < 0L) {
            freePesNumber = 0L;
        }
        this.freePesNumber = Math.min(freePesNumber, this.getPesNumber());
        return this;
    }

    public Vm addExpectedFreePesNumber(long pesToAdd) {
        return this.setExpectedFreePesNumber(this.expectedFreePesNumber + pesToAdd);
    }

    public Vm removeExpectedFreePesNumber(long pesToRemove) {
        return this.setExpectedFreePesNumber(this.expectedFreePesNumber - pesToRemove);
    }

    private Vm setExpectedFreePesNumber(long expectedFreePes) {
        this.expectedFreePesNumber = Math.max(expectedFreePes, 0L);
        return this;
    }

    @Override
    public double getCpuPercentUtilization() {
        return this.getCpuPercentUtilization(this.getSimulation().clock());
    }

    @Override
    public double getCpuPercentUtilization(double time) {
        return this.cloudletScheduler.getAllocatedCpuPercent(time);
    }

    @Override
    public double getCpuPercentRequested() {
        return this.getCpuPercentRequested(this.getSimulation().clock());
    }

    @Override
    public double getCpuPercentRequested(double time) {
        return this.cloudletScheduler.getRequestedCpuPercent(time);
    }

    @Override
    public double getHostCpuUtilization(double time) {
        return this.host.getExpectedRelativeCpuUtilization(this, this.getCpuPercentUtilization(time));
    }

    @Override
    public double getExpectedHostCpuUtilization(double vmCpuUtilizationPercent) {
        return this.host.getExpectedRelativeCpuUtilization(this, vmCpuUtilizationPercent);
    }

    @Override
    public double getHostRamUtilization() {
        return this.host.getRelativeRamUtilization(this);
    }

    @Override
    public double getHostBwUtilization() {
        return this.host.getRelativeBwUtilization(this);
    }

    @Override
    public double getTotalCpuMipsUtilization() {
        return this.getTotalCpuMipsUtilization(this.getSimulation().clock());
    }

    @Override
    public double getTotalCpuMipsUtilization(double time) {
        return this.getCpuPercentUtilization(time) * this.getTotalMipsCapacity();
    }

    @Override
    public double getTotalCpuMipsRequested() {
        return this.getCurrentRequestedMips().totalMips();
    }

    @Override
    public MipsShare getCurrentRequestedMips() {
        if (this.isCreated()) {
            return this.host.getVmScheduler().getRequestedMips(this);
        }
        return new MipsShare(this.processor);
    }

    @Override
    public long getCurrentRequestedBw() {
        if (!this.isCreated()) {
            return this.bw.getCapacity();
        }
        return (long)(this.cloudletScheduler.getCurrentRequestedBwPercentUtilization() * (double)this.bw.getCapacity());
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.getMips() * (double)this.getPesNumber();
    }

    @Override
    public long getCurrentRequestedRam() {
        if (this.isCreated()) {
            return (long)(this.cloudletScheduler.getCurrentRequestedRamPercentUtilization() * (double)this.ram.getCapacity());
        }
        return this.ram.getCapacity();
    }

    @Override
    public Vm setStartTime(double startTime) {
        this.startTime = MathUtil.nonNegative(startTime, "startTime");
        this.setLastBusyTime(startTime);
        return this;
    }

    @Override
    public Vm setStopTime(double stopTime) {
        this.stopTime = Math.max(stopTime, -1.0);
        return this;
    }

    public boolean hasStartedSomeCloudlet() {
        return this.lastBusyTime != Double.MAX_VALUE;
    }

    private void setLastBusyTime() {
        this.lastBusyTime = this.getSimulation().clock();
    }

    private void setLastBusyTime(double time) {
        this.lastBusyTime = time;
    }

    @Override
    public double getTotalExecutionTime() {
        if (this.startTime < 0.0) {
            return 0.0;
        }
        return this.stopTime < 0.0 ? this.getSimulation().clock() - this.startTime : this.stopTime - this.startTime;
    }

    @Override
    public double getMips() {
        return this.processor.getMips();
    }

    protected final void setMips(double mips) {
        this.processor.setMips(mips);
    }

    @Override
    public long getPesNumber() {
        return this.processor.getCapacity();
    }

    private void setPesNumber(long pesNumber) {
        this.processor.setCapacity(pesNumber);
    }

    private void setRam(@NonNull Ram ram) {
        if (ram == null) {
            throw new NullPointerException("ram is marked non-null but is null");
        }
        this.ram = ram;
    }

    @Override
    public final Vm setRam(long ramCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("RAM capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setRam(new Ram(ramCapacity));
        return this;
    }

    private void setBw(@NonNull Bandwidth bw) {
        if (bw == null) {
            throw new NullPointerException("bw is marked non-null but is null");
        }
        this.bw = bw;
    }

    @Override
    public final Vm setBw(long bwCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Bandwidth capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setBw(new Bandwidth(bwCapacity));
        return this;
    }

    private void setStorage(@NonNull SimpleStorage storage) {
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        this.storage = storage;
    }

    @Override
    public final Vm setSize(long size) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Storage size can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setStorage(new SimpleStorage(size));
        return this;
    }

    @Override
    public Vm setHost(@NonNull Host host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (Host.NULL.equals(host)) {
            this.setCreated(false);
        }
        this.host = host;
        return this;
    }

    @Override
    public final Vm setCloudletScheduler(@NonNull CloudletScheduler cloudletScheduler) {
        if (cloudletScheduler == null) {
            throw new NullPointerException("cloudletScheduler is marked non-null but is null");
        }
        if (this.isCreated()) {
            throw new UnsupportedOperationException("CloudletScheduler can just be changed when the Vm was not created inside a Host yet.");
        }
        this.cloudletScheduler = cloudletScheduler;
        this.cloudletScheduler.setVm(this);
        return this;
    }

    public void updateMigrationStartListeners(Host targetHost) {
        for (int i = 0; i < this.onMigrationStartListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onMigrationStartListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, targetHost));
        }
    }

    public void updateMigrationFinishListeners(Host targetHost) {
        for (int i = 0; i < this.onMigrationFinishListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onMigrationFinishListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, targetHost));
        }
    }

    @Override
    public boolean isSuitableForCloudlet(Cloudlet cloudlet) {
        return this.getPesNumber() >= cloudlet.getPesNumber() && this.storage.getAvailableResource() >= cloudlet.getFileSize();
    }

    @Override
    public void setCreated(boolean created) {
        if (!this.created && created) {
            this.setCreationTime();
        }
        this.created = created;
        this.setFailed(false);
    }

    @Override
    public List<VmStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public void addStateHistoryEntry(VmStateHistoryEntry entry) {
        VmStateHistoryEntry previousState;
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == entry.getTime()) {
            this.stateHistory.set(this.stateHistory.size() - 1, entry);
            return;
        }
        this.stateHistory.add(entry);
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.getSimulation().isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ram, this.bw, this.storage, this.processor);
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceManageable getResource(Class<? extends ResourceManageable> resourceClass) {
        if (Pe.class.isAssignableFrom(resourceClass) || Processor.class.isAssignableFrom(resourceClass)) {
            return this.processor;
        }
        return Vm.super.getResource(resourceClass);
    }

    @Override
    public Vm addOnHostAllocationListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onHostAllocationListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnMigrationStartListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onMigrationStartListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnMigrationFinishListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onMigrationFinishListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnHostDeallocationListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onHostDeallocationListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnCreationFailureListener(@NonNull EventListener<VmDatacenterEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onCreationFailureListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnUpdateProcessingListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnCreationFailureListener(@NonNull EventListener<VmDatacenterEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onCreationFailureListeners.remove(listener);
    }

    @Override
    public boolean removeOnUpdateProcessingListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public boolean removeOnHostAllocationListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onHostAllocationListeners.remove(listener);
    }

    @Override
    public boolean removeOnHostDeallocationListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onHostDeallocationListeners.remove(listener);
    }

    public String toString() {
        String desc = StringUtils.isBlank((CharSequence)this.description) ? "" : " (%s)".formatted(this.description);
        String type = this instanceof VmGroup ? "VmGroup" : "Vm";
        return "%s %d%s".formatted(type, this.getId(), desc);
    }

    @Override
    public int compareTo(@NonNull Vm obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (this.equals(obj)) {
            return 0;
        }
        return Double.compare(this.getTotalMipsCapacity(), obj.getTotalMipsCapacity()) + Long.compare(this.getId(), obj.getId()) + this.getBroker().compareTo(obj.getBroker());
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
        if (failed) {
            this.setCloudletsToFailed();
        }
    }

    public void setCloudletsToFailed() {
        this.getBroker().getCloudletWaitingList().stream().filter(cl -> this.equals(cl.getVm())).forEach(cl -> cl.setStatus(Cloudlet.Status.FAILED_RESOURCE_UNAVAILABLE));
    }

    @Override
    public boolean isWorking() {
        return !this.isFailed();
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        this.submissionDelay = MathUtil.nonNegative(submissionDelay, "submissionDelay");
    }

    @Override
    public boolean isDelayed() {
        return this.submissionDelay > 0.0;
    }

    @Override
    public void notifyOnHostAllocationListeners() {
        for (int i = 0; i < this.onHostAllocationListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onHostAllocationListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this));
        }
    }

    @Override
    public void notifyOnHostDeallocationListeners(@NonNull Host deallocatedHost) {
        if (deallocatedHost == null) {
            throw new NullPointerException("deallocatedHost is marked non-null but is null");
        }
        for (int i = 0; i < this.onHostDeallocationListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onHostDeallocationListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, deallocatedHost));
        }
    }

    public void notifyOnUpdateProcessingListeners() {
        for (int i = 0; i < this.onUpdateProcessingListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onUpdateProcessingListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this));
        }
    }

    @Override
    public void notifyOnCreationFailureListeners(@NonNull Datacenter failedDatacenter) {
        if (failedDatacenter == null) {
            throw new NullPointerException("failedDatacenter is marked non-null but is null");
        }
        for (int i = 0; i < this.onCreationFailureListeners.size(); ++i) {
            EventListener<VmDatacenterEventInfo> listener = this.onCreationFailureListeners.get(i);
            listener.update(VmDatacenterEventInfo.of(listener, this, failedDatacenter));
        }
    }

    @Override
    public boolean removeOnMigrationStartListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onMigrationStartListeners.remove(listener);
    }

    @Override
    public boolean removeOnMigrationFinishListener(@NonNull EventListener<VmHostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onMigrationFinishListeners.remove(listener);
    }

    @Override
    public final Vm setHorizontalScaling(HorizontalVmScaling horizontalScaling) throws IllegalArgumentException {
        this.horizontalScaling = this.validateAndConfigureVmScaling(horizontalScaling);
        return this;
    }

    @Override
    public final Vm setRamVerticalScaling(VerticalVmScaling ramVerticalScaling) throws IllegalArgumentException {
        this.ramVerticalScaling = this.validateAndConfigureVmScaling(ramVerticalScaling);
        return this;
    }

    @Override
    public final Vm setBwVerticalScaling(VerticalVmScaling bwVerticalScaling) throws IllegalArgumentException {
        this.bwVerticalScaling = this.validateAndConfigureVmScaling(bwVerticalScaling);
        return this;
    }

    @Override
    public final Vm setPeVerticalScaling(VerticalVmScaling peVerticalScaling) throws IllegalArgumentException {
        this.peVerticalScaling = this.validateAndConfigureVmScaling(peVerticalScaling);
        return this;
    }

    private <T extends VmScaling> T validateAndConfigureVmScaling(@NonNull T vmScaling) {
        if (vmScaling == null) {
            throw new NullPointerException("vmScaling is marked non-null but is null");
        }
        if (vmScaling.getVm() != null && vmScaling.getVm() != NULL && vmScaling.getVm() != this) {
            String name = vmScaling.getClass().getSimpleName();
            throw new IllegalArgumentException("The " + name + " given is already linked to a Vm. Each Vm must have its own " + name + " object or none at all. Another " + name + " has to be provided for this Vm.");
        }
        vmScaling.setVm(this);
        this.addOnUpdateProcessingListener(vmScaling::requestUpScalingIfPredicateMatches);
        return vmScaling;
    }

    @Override
    public void enableUtilizationStats() {
        if (this.cpuUtilizationStats == null || this.cpuUtilizationStats == VmResourceStats.NULL) {
            this.cpuUtilizationStats = new VmResourceStats(this, vm -> vm.getCpuPercentUtilization(this.getSimulation().clock()));
        }
    }

    public static long getDefaultRamCapacity() {
        return defaultRamCapacity;
    }

    public static void setDefaultRamCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultRamCapacity = defaultCapacity;
    }

    public static long getDefaultBwCapacity() {
        return defaultBwCapacity;
    }

    public static void setDefaultBwCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultBwCapacity = defaultCapacity;
    }

    public static long getDefaultStorageCapacity() {
        return defaultStorageCapacity;
    }

    public static void setDefaultStorageCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultStorageCapacity = defaultCapacity;
    }

    @Override
    public Vm setTimeZone(double timeZone) {
        this.timeZone = this.validateTimeZone(timeZone);
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVmm() {
        return this.vmm;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public double getTimeZone() {
        return this.timeZone;
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public double getStopTime() {
        return this.stopTime;
    }

    @Override
    public double getLastBusyTime() {
        return this.lastBusyTime;
    }

    @Override
    @NonNull
    public VmGroup getGroup() {
        return this.group;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public SimpleStorage getStorage() {
        return this.storage;
    }

    @Override
    public Ram getRam() {
        return this.ram;
    }

    @Override
    public Bandwidth getBw() {
        return this.bw;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    @NonNull
    public CloudletScheduler getCloudletScheduler() {
        return this.cloudletScheduler;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public boolean isInMigration() {
        return this.inMigration;
    }

    @Override
    public long getFreePesNumber() {
        return this.freePesNumber;
    }

    @Override
    public long getExpectedFreePesNumber() {
        return this.expectedFreePesNumber;
    }

    @Override
    public HorizontalVmScaling getHorizontalScaling() {
        return this.horizontalScaling;
    }

    @Override
    public VerticalVmScaling getRamVerticalScaling() {
        return this.ramVerticalScaling;
    }

    @Override
    public VerticalVmScaling getBwVerticalScaling() {
        return this.bwVerticalScaling;
    }

    @Override
    public VerticalVmScaling getPeVerticalScaling() {
        return this.peVerticalScaling;
    }

    @NonNull
    public MipsShare getAllocatedMips() {
        return this.allocatedMips;
    }

    @NonNull
    public MipsShare getRequestedMips() {
        return this.requestedMips;
    }

    @Override
    public VmResourceStats getCpuUtilizationStats() {
        return this.cpuUtilizationStats;
    }

    public List<EventListener<VmHostEventInfo>> getOnMigrationStartListeners() {
        return this.onMigrationStartListeners;
    }

    public List<EventListener<VmHostEventInfo>> getOnMigrationFinishListeners() {
        return this.onMigrationFinishListeners;
    }

    public List<EventListener<VmHostEventInfo>> getOnHostAllocationListeners() {
        return this.onHostAllocationListeners;
    }

    public List<EventListener<VmHostEventInfo>> getOnHostDeallocationListeners() {
        return this.onHostDeallocationListeners;
    }

    public List<EventListener<VmHostEventInfo>> getOnUpdateProcessingListeners() {
        return this.onUpdateProcessingListeners;
    }

    public List<EventListener<VmDatacenterEventInfo>> getOnCreationFailureListeners() {
        return this.onCreationFailureListeners;
    }

    @Override
    public VmSimple setDescription(String description) {
        this.description = description;
        return this;
    }

    public VmSimple setVmm(String vmm) {
        this.vmm = vmm;
        return this;
    }

    public VmSimple setGroup(@NonNull VmGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
        return this;
    }

    @Override
    public VmSimple setInMigration(boolean inMigration) {
        this.inMigration = inMigration;
        return this;
    }

    public VmSimple setAllocatedMips(@NonNull MipsShare allocatedMips) {
        if (allocatedMips == null) {
            throw new NullPointerException("allocatedMips is marked non-null but is null");
        }
        this.allocatedMips = allocatedMips;
        return this;
    }

    public VmSimple setRequestedMips(@NonNull MipsShare requestedMips) {
        if (requestedMips == null) {
            throw new NullPointerException("requestedMips is marked non-null but is null");
        }
        this.requestedMips = requestedMips;
        return this;
    }
}

