/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

import java.util.Objects;
import org.cloudsimplus.datacenters.DatacenterCharacteristics;
import org.cloudsimplus.vms.Vm;

public class VmCost {
    private final Vm vm;

    public VmCost(Vm vm) {
        this.vm = Objects.requireNonNull(vm);
    }

    private DatacenterCharacteristics getDcCharacteristics() {
        return this.vm.getHost().getDatacenter().getCharacteristics();
    }

    public double getMemoryCost() {
        return this.getDcCharacteristics().getCostPerMem() * (double)this.vm.getRam().getCapacity();
    }

    public double getBwCost() {
        return this.getDcCharacteristics().getCostPerBw() * (double)this.vm.getBw().getCapacity();
    }

    public double getProcessingCost() {
        double hostMips = this.vm.getHost().getMips();
        double costPerMI = hostMips == 0.0 ? 0.0 : this.getDcCharacteristics().getCostPerSecond() / hostMips;
        return costPerMI * this.vm.getTotalMipsCapacity() * this.vm.getTotalExecutionTime();
    }

    public double getStorageCost() {
        return this.getDcCharacteristics().getCostPerStorage() * (double)this.vm.getStorage().getCapacity();
    }

    public double getTotalCost() {
        return this.getProcessingCost() + this.getStorageCost() + this.getMemoryCost() + this.getBwCost();
    }

    public String toString() {
        return "%s costs ($) for %8.2f execution seconds - CPU: %8.2f$ RAM: %8.2f$ Storage: %8.2f$ BW: %8.2f$ Total: %8.2f$".formatted(this.vm, this.getVm().getTotalExecutionTime(), this.getProcessingCost(), this.getMemoryCost(), this.getStorageCost(), this.getBwCost(), this.getTotalCost());
    }

    public final Vm getVm() {
        return this.vm;
    }
}

