/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vms;

import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudsimplus.core.AbstractMachine;

public class ResourceStats<T extends AbstractMachine> {
    private final Function<T, Double> resourceUtilizationFunction;
    private final T machine;
    private final SummaryStatistics stats;
    private double previousTime;
    private double previousUtilization;

    protected ResourceStats(@NonNull T machine, @NonNull Function<T, Double> resourceUtilizationFunction) {
        if (machine == null) {
            throw new NullPointerException("machine is marked non-null but is null");
        }
        if (resourceUtilizationFunction == null) {
            throw new NullPointerException("resourceUtilizationFunction is marked non-null but is null");
        }
        this.resourceUtilizationFunction = resourceUtilizationFunction;
        this.machine = machine;
        this.stats = new SummaryStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(double time) {
        double utilization;
        block5: {
            block4: {
                boolean bl;
                try {
                    if (!this.isNotTimeToAddHistory(time)) break block4;
                    bl = false;
                    this.previousTime = this.machine.isIdle() ? time : (double)((int)time);
                }
                catch (Throwable throwable) {
                    this.previousTime = this.machine.isIdle() ? time : (double)((int)time);
                    throw throwable;
                }
                return bl;
            }
            utilization = this.resourceUtilizationFunction.apply(this.machine);
            if ((this.previousUtilization == 0.0 || utilization != 0.0) && (!this.machine.isIdle() || !(this.previousUtilization > 0.0))) break block5;
            this.previousUtilization = utilization;
            boolean bl = false;
            this.previousTime = this.machine.isIdle() ? time : (double)((int)time);
            return bl;
        }
        this.stats.addValue(utilization);
        this.previousUtilization = utilization;
        boolean bl = true;
        this.previousTime = this.machine.isIdle() ? time : (double)((int)time);
        return bl;
    }

    public double getMin() {
        return this.stats.getMin();
    }

    public double getMax() {
        return this.stats.getMax();
    }

    public double getMean() {
        return this.stats.getMean();
    }

    public double getStandardDeviation() {
        return this.stats.getStandardDeviation();
    }

    public double getVariance() {
        return this.stats.getVariance();
    }

    public double count() {
        return this.stats.getN();
    }

    public boolean isEmpty() {
        return this.count() == 0.0;
    }

    protected final boolean isNotTimeToAddHistory(double time) {
        return time <= 0.0 || this.isElapsedTimeSmall(time) || this.isNotEntireSecondElapsed(time);
    }

    protected final boolean isElapsedTimeSmall(double time) {
        return time - this.previousTime < 1.0 && !this.machine.isIdle();
    }

    protected final boolean isNotEntireSecondElapsed(double time) {
        return Math.floor(time) == this.previousTime && !this.machine.isIdle();
    }

    protected T getMachine() {
        return this.machine;
    }

    protected double getPreviousTime() {
        return this.previousTime;
    }
}

