/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.utilizationmodels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.distributions.UniformDistr;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelStochastic
extends UtilizationModelAbstract {
    @NonNull
    private ContinuousDistribution randomGenerator;
    private Map<Double, Double> historyMap;
    private double previousTime;
    private double maxPreviousTime;
    private double previousUtilization;
    private boolean historyEnabled;
    private boolean alwaysGenNewRandUtilization;

    public UtilizationModelStochastic() {
        this(UtilizationModel.Unit.PERCENTAGE);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit) {
        this(unit, StatisticalDistribution.defaultSeed());
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit, long seed) {
        this(unit, new UniformDistr(seed));
    }

    public UtilizationModelStochastic(long seed) {
        this(UtilizationModel.Unit.PERCENTAGE, new UniformDistr(seed));
    }

    public UtilizationModelStochastic(ContinuousDistribution prng) {
        this(UtilizationModel.Unit.PERCENTAGE, prng);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit, @NonNull ContinuousDistribution prng) {
        super(unit);
        if (prng == null) {
            throw new NullPointerException("prng is marked non-null but is null");
        }
        this.previousTime = -1.0;
        this.previousUtilization = -1.0;
        this.maxPreviousTime = -1.0;
        this.historyEnabled = true;
        this.historyMap = new HashMap<Double, Double>();
        this.setRandomGenerator(prng);
    }

    @Override
    protected double getUtilizationInternal(double time) {
        if (time == this.previousTime && !this.alwaysGenNewRandUtilization) {
            return this.previousUtilization;
        }
        double utilization = this.getOrGenerateUtilization(time);
        this.maxPreviousTime = Math.max(this.maxPreviousTime, time);
        this.previousTime = time;
        this.previousUtilization = utilization;
        return utilization;
    }

    private Double getOrGenerateUtilization(double time) {
        if (time > this.maxPreviousTime || this.alwaysGenNewRandUtilization) {
            return this.generateUtilization(time);
        }
        Double utilization = this.historyEnabled ? this.historyMap.get(time) : null;
        return utilization == null ? this.generateUtilization(time) : utilization.doubleValue();
    }

    private double generateUtilization(double time) {
        double utilization = Math.abs(this.randomGenerator.sample());
        if (this.historyEnabled) {
            this.historyMap.put(time, utilization);
        }
        return utilization;
    }

    protected Double getUtilizationHistory(double time) {
        return this.historyMap.get(time);
    }

    public void saveHistory(String filename) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));){
            oos.writeObject(this.historyMap);
        }
    }

    public void loadHistory(String filename) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));){
            this.historyMap = (Map)ois.readObject();
        }
    }

    @NonNull
    public final ContinuousDistribution getRandomGenerator() {
        return this.randomGenerator;
    }

    public final UtilizationModelStochastic setRandomGenerator(@NonNull ContinuousDistribution randomGenerator) {
        if (randomGenerator == null) {
            throw new NullPointerException("randomGenerator is marked non-null but is null");
        }
        this.randomGenerator = randomGenerator;
        return this;
    }

    public final boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    public final UtilizationModelStochastic setHistoryEnabled(boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
        return this;
    }

    public final boolean isAlwaysGenNewRandUtilization() {
        return this.alwaysGenNewRandUtilization;
    }

    public final UtilizationModelStochastic setAlwaysGenNewRandUtilization(boolean alwaysGenNewRandUtilization) {
        this.alwaysGenNewRandUtilization = alwaysGenNewRandUtilization;
        return this;
    }
}

