/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.utilizationmodels;

import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelDynamic
extends UtilizationModelAbstract {
    private boolean readOnly = false;
    private double currentUtilization;
    private double maxResourceUtilization;
    @NonNull
    private Function<UtilizationModelDynamic, Double> utilizationUpdateFunction;
    private double previousUtilizationTime;
    private double currentUtilizationTime;

    public UtilizationModelDynamic() {
        this(UtilizationModel.Unit.PERCENTAGE, 0.0);
    }

    public UtilizationModelDynamic(UtilizationModel.Unit unit) {
        this(unit, 0.0);
    }

    public UtilizationModelDynamic(double initialUtilizationPercent) {
        this(UtilizationModel.Unit.PERCENTAGE, initialUtilizationPercent);
    }

    public UtilizationModelDynamic(double initialUtilization, double maxResourceUtilization) {
        this(UtilizationModel.Unit.PERCENTAGE, initialUtilization, maxResourceUtilization);
    }

    public UtilizationModelDynamic(UtilizationModel.Unit unit, double initialUtilization) {
        this(unit, initialUtilization, unit == UtilizationModel.Unit.PERCENTAGE ? 1.0 : 0.0);
    }

    public UtilizationModelDynamic(UtilizationModel.Unit unit, double initialUtilization, double maxResourceUtilization) {
        super(unit);
        this.setMaxResourceUtilization(maxResourceUtilization);
        this.previousUtilizationTime = 0.0;
        this.currentUtilizationTime = 0.0;
        this.setCurrentUtilization(initialUtilization);
        this.utilizationUpdateFunction = modelInstance -> modelInstance.currentUtilization;
    }

    protected UtilizationModelDynamic(UtilizationModelDynamic source) {
        this(source, source.currentUtilization);
        this.utilizationUpdateFunction = modelInstance -> modelInstance.currentUtilization;
        this.readOnly = true;
    }

    public UtilizationModelDynamic(@NonNull UtilizationModelDynamic source, double initialUtilization) {
        this(source.getUnit(), initialUtilization);
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.currentUtilizationTime = source.currentUtilizationTime;
        this.previousUtilizationTime = source.previousUtilizationTime;
        this.maxResourceUtilization = source.maxResourceUtilization;
        this.setSimulation(source.getSimulation());
        this.setUtilizationUpdateFunction(source.utilizationUpdateFunction);
    }

    @Override
    protected double getUtilizationInternal(double time) {
        if (this.readOnly) {
            return this.currentUtilization;
        }
        this.currentUtilizationTime = time;
        if (this.previousUtilizationTime == time) {
            return this.currentUtilization;
        }
        this.currentUtilization = this.utilizationUpdateFunction.apply(new UtilizationModelDynamic(this));
        this.previousUtilizationTime = time;
        if (this.currentUtilization <= 0.0) {
            this.currentUtilization = 0.0;
        }
        if (this.currentUtilization > this.maxResourceUtilization && this.maxResourceUtilization > 0.0) {
            this.currentUtilization = this.maxResourceUtilization;
        }
        return this.currentUtilization;
    }

    public double getTimeSpan() {
        return this.currentUtilizationTime - this.previousUtilizationTime;
    }

    private void setCurrentUtilization(double currentUtilization) {
        this.validateUtilizationField("currentUtilization", currentUtilization);
        this.currentUtilization = currentUtilization;
    }

    public final UtilizationModelDynamic setMaxResourceUtilization(double maxResourceUsage) {
        this.validateUtilizationField("maxResourceUtilization", maxResourceUsage, 1.0E-10);
        this.maxResourceUtilization = maxResourceUsage;
        return this;
    }

    public final double getMaxResourceUtilization() {
        return this.maxResourceUtilization;
    }

    public final UtilizationModelDynamic setUtilizationUpdateFunction(@NonNull Function<UtilizationModelDynamic, Double> utilizationUpdateFunction) {
        if (utilizationUpdateFunction == null) {
            throw new NullPointerException("utilizationUpdateFunction is marked non-null but is null");
        }
        this.utilizationUpdateFunction = utilizationUpdateFunction;
        return this;
    }
}

