/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import org.cloudsimplus.util.TraceReader;

public abstract class TraceReaderAbstract
implements TraceReader {
    private final String filePath;
    private final InputStream inputStream;
    @NonNull
    private String fieldDelimiterRegex;
    private int maxLinesToRead;
    private String[] commentString = new String[]{";", "#"};
    private int lastLineNumber;

    public TraceReaderAbstract(@NonNull String filePath) throws IOException {
        this(filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
    }

    protected TraceReaderAbstract(@NonNull String filePath, @NonNull InputStream inputStream) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (filePath.isEmpty()) {
            throw new IllegalArgumentException("Invalid trace file name.");
        }
        this.fieldDelimiterRegex = "\\s+";
        this.setMaxLinesToRead(Integer.MAX_VALUE);
        this.inputStream = inputStream;
        this.filePath = filePath;
    }

    @Override
    public TraceReader setCommentString(String ... commentString) {
        if (commentString == null) {
            throw new NullPointerException("commentString is marked non-null but is null");
        }
        if (commentString.length == 0) {
            throw new IllegalArgumentException("A comment String is required");
        }
        this.commentString = Arrays.copyOf(commentString, commentString.length);
        return this;
    }

    @Override
    public String[] getCommentString() {
        return Arrays.copyOf(this.commentString, this.commentString.length);
    }

    @Override
    public final TraceReader setMaxLinesToRead(int maxLinesToRead) {
        if (maxLinesToRead <= 0) {
            throw new IllegalArgumentException("Maximum number of lines to read from the trace must be greater than 0. If you want to read the entire file, provide Integer.MAX_VALUE.");
        }
        this.maxLinesToRead = maxLinesToRead;
        return this;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected String[] parseTraceLine(String line) {
        if (this.isComment(line)) {
            return new String[0];
        }
        return line.trim().split(this.fieldDelimiterRegex, -1);
    }

    private boolean isComment(String line) {
        return Arrays.stream(this.commentString).anyMatch(line::startsWith);
    }

    protected void readTextFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        this.readFile(inputStream, processParsedLineFunction);
    }

    protected void readGZIPFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        this.readFile(new GZIPInputStream(inputStream), processParsedLineFunction);
    }

    protected boolean readZipFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(Objects.requireNonNull(inputStream));){
            while (zipInputStream.getNextEntry() != null) {
                this.readFile(zipInputStream, processParsedLineFunction);
            }
            boolean bl = true;
            return bl;
        }
    }

    protected void readFile(Function<String[], Boolean> processParsedLineFunction) {
        try {
            if (this.getFilePath().endsWith(".gz")) {
                this.readGZIPFile(this.getInputStream(), processParsedLineFunction);
            } else if (this.getFilePath().endsWith(".zip")) {
                this.readZipFile(this.getInputStream(), processParsedLineFunction);
            } else {
                this.readTextFile(this.getInputStream(), processParsedLineFunction);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void readFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        String line;
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(processParsedLineFunction);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.lastLineNumber = 0;
        while ((line = this.readNextLine(reader, this.lastLineNumber)) != null) {
            String[] parsedTraceLine = this.parseTraceLine(line);
            if (parsedTraceLine.length <= 0 || !processParsedLineFunction.apply(parsedTraceLine).booleanValue()) continue;
            ++this.lastLineNumber;
        }
    }

    private String readNextLine(BufferedReader reader, int lineNumber) throws IOException {
        if (reader.ready() && lineNumber <= this.maxLinesToRead - 1) {
            return reader.readLine();
        }
        return null;
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    @NonNull
    public final String getFieldDelimiterRegex() {
        return this.fieldDelimiterRegex;
    }

    @Override
    public final TraceReaderAbstract setFieldDelimiterRegex(@NonNull String fieldDelimiterRegex) {
        if (fieldDelimiterRegex == null) {
            throw new NullPointerException("fieldDelimiterRegex is marked non-null but is null");
        }
        this.fieldDelimiterRegex = fieldDelimiterRegex;
        return this;
    }

    @Override
    public final int getMaxLinesToRead() {
        return this.maxLinesToRead;
    }

    @Override
    public final int getLastLineNumber() {
        return this.lastLineNumber;
    }
}

