/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

public final class TimeUtil {
    private static final double MINUTE_SECS = 60.0;
    private static final double HOUR_SECS = 3600.0;
    private static final double DAY_SECS = 86400.0;
    private static final double MONTH_SECS = 2592000.0;
    private static final double YEAR_SECS = 3.1104E7;

    private TimeUtil() {
    }

    public static String secondsToStr(double seconds) {
        if (seconds < 60.0) {
            return TimeUtil.convertSeconds(seconds, 1.0, "second");
        }
        if (seconds < 3600.0) {
            return TimeUtil.convertSeconds(seconds, 60.0, "minute");
        }
        if (seconds < 86400.0) {
            return TimeUtil.convertSeconds(seconds, 3600.0, "hour");
        }
        if (seconds < 2592000.0) {
            return TimeUtil.convertSeconds(seconds, 86400.0, "day");
        }
        if (seconds < 3.1104E7) {
            return TimeUtil.convertSeconds(seconds, 2592000.0, "month");
        }
        return TimeUtil.convertSeconds(seconds, 3.1104E7, "year");
    }

    private static String convertSeconds(double seconds, double conversionFactor, String unit) {
        double convertedTime = seconds / conversionFactor;
        return "%.2f %s".formatted(convertedTime, convertedTime >= 2.0 ? unit + "s" : unit);
    }

    public static double currentTimeSecs() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double elapsedSeconds(double startTimeSeconds) {
        return TimeUtil.currentTimeSecs() - startTimeSeconds;
    }

    public static long elapsedSeconds(long startTimeSeconds) {
        return (long)TimeUtil.elapsedSeconds((double)startTimeSeconds);
    }

    public static double microToMilli(double micro) {
        return micro / 1000.0;
    }

    public static double microToSeconds(double micro) {
        return TimeUtil.microToMilli(micro) / 1000.0;
    }

    public static double minutesToSeconds(double minutes) {
        return minutes * 60.0;
    }

    public static double millisecsToMinutes(long milli) {
        return (double)milli / 60000.0;
    }

    public static double secondsToMinutes(double seconds) {
        return seconds / 60.0;
    }

    public static double secondsToHours(double seconds) {
        return TimeUtil.secondsToMinutes(seconds) / 60.0;
    }

    public static double secondsToDays(double seconds) {
        return TimeUtil.hoursToDays(TimeUtil.secondsToHours(seconds));
    }

    public static double hoursToDays(double hours) {
        return hours / 24.0;
    }

    public static double hoursToMinutes(double hours) {
        return hours * 60.0;
    }

    public static double hoursToSeconds(double hours) {
        return TimeUtil.minutesToSeconds(hours * 60.0);
    }

    public static double daysToSeconds(double days) {
        return TimeUtil.hoursToSeconds(days * 24.0);
    }

    public static double daysToHours(double days) {
        return days * 24.0;
    }

    public static double monthsToSeconds(double months) {
        return TimeUtil.daysToSeconds(months * 30.0);
    }
}

