/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.cloudlets.CloudletSimple;
import org.cloudsimplus.util.ResourceLoader;
import org.cloudsimplus.util.TraceReaderAbstract;
import org.cloudsimplus.utilizationmodels.UtilizationModelFull;

public final class SwfWorkloadFileReader
extends TraceReaderAbstract {
    private static final int JOB_NUM_INDEX = 0;
    private static final int SUBMIT_TIME_INDEX = 1;
    private static final int RUN_TIME_INDEX = 3;
    private static final int NUM_PROC_INDEX = 4;
    private static final int REQ_NUM_PROC_INDEX = 7;
    private static final int FIELD_COUNT = 18;
    private static final int IRRELEVANT = -1;
    private int mips;
    private final List<Cloudlet> cloudlets;
    private Predicate<Cloudlet> predicate;

    public SwfWorkloadFileReader(@NonNull String filePath, int mips) throws IOException {
        this(filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), mips);
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
    }

    private SwfWorkloadFileReader(String filePath, InputStream reader, int mips) {
        super(filePath, reader);
        this.setMips(mips);
        this.cloudlets = new ArrayList<Cloudlet>();
        this.predicate = cloudlet -> true;
    }

    public static SwfWorkloadFileReader getInstance(String fileName, int mips) {
        InputStream reader = ResourceLoader.newInputStream(fileName, SwfWorkloadFileReader.class);
        return new SwfWorkloadFileReader(fileName, reader, mips);
    }

    public List<Cloudlet> generateWorkload() {
        if (this.cloudlets.isEmpty()) {
            this.readFile(this::createCloudletFromTraceLine);
        }
        return this.cloudlets;
    }

    private boolean createCloudletFromTraceLine(String[] parsedLineArray) {
        if (parsedLineArray.length < 18) {
            return false;
        }
        int id = Integer.parseInt(parsedLineArray[0].trim());
        int runTime = Math.max(Integer.parseInt(parsedLineArray[3].trim()), 1);
        int maxNumProc = Math.max(Integer.parseInt(parsedLineArray[7].trim()), Integer.parseInt(parsedLineArray[4].trim()));
        int numProc = Math.max(maxNumProc, 1);
        Cloudlet cloudlet = this.createCloudlet(id, runTime, numProc);
        long submitTime = Long.parseLong(parsedLineArray[1].trim());
        cloudlet.setSubmissionDelay(submitTime);
        if (this.predicate.test(cloudlet)) {
            this.cloudlets.add(cloudlet);
            return true;
        }
        return false;
    }

    private Cloudlet createCloudlet(int id, int runTime, int numProc) {
        int len = runTime * this.mips;
        UtilizationModelFull utilizationModel = new UtilizationModelFull();
        return new CloudletSimple((long)id, (long)len, numProc).setFileSize(1500L).setOutputSize(1500L).setUtilizationModel(utilizationModel);
    }

    public SwfWorkloadFileReader setMips(int mips) {
        if (mips <= 0) {
            throw new IllegalArgumentException("MIPS must be greater than 0.");
        }
        this.mips = mips;
        return this;
    }

    public final int getMips() {
        return this.mips;
    }

    public final SwfWorkloadFileReader setPredicate(Predicate<Cloudlet> predicate) {
        this.predicate = predicate;
        return this;
    }
}

