/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskData;
import org.cloudsimplus.traces.google.TaskEventField;
import org.cloudsimplus.traces.google.TaskEventType;

public final class TaskEvent
extends TaskData {
    private int priority;
    private int schedulingClass;
    private TaskEventType type;
    private double resourceRequestForCpuCores;
    private double resourceRequestForRam;
    private double resourceRequestForLocalDiskSpace;
    private String userName;
    private double timestamp;

    public long actualCpuCores(long maxCpuCores) {
        return (long)(this.resourceRequestForCpuCores * (double)maxCpuCores);
    }

    public TaskEvent setType(int type) {
        this.type = TaskEventType.getValue(type);
        return this;
    }

    public static TaskEvent of(GoogleTaskEventsTraceReader reader) {
        Builder builder = new Builder();
        builder.type((TaskEventType)((Object)TaskEventField.EVENT_TYPE.getValue(reader))).timestamp((Double)TaskEventField.TIMESTAMP.getValue(reader)).resourceRequestForCpuCores((Double)TaskEventField.RESOURCE_REQUEST_FOR_CPU_CORES.getValue(reader)).resourceRequestForLocalDiskSpace((Double)TaskEventField.RESOURCE_REQUEST_FOR_LOCAL_DISK_SPACE.getValue(reader)).resourceRequestForRam((Double)TaskEventField.RESOURCE_REQUEST_FOR_RAM.getValue(reader)).priority((Integer)TaskEventField.PRIORITY.getValue(reader)).schedulingClass((Integer)TaskEventField.SCHEDULING_CLASS.getValue(reader)).userName((String)TaskEventField.USERNAME.getValue(reader));
        TaskEvent evt = builder.build();
        evt.setJobId((Long)TaskEventField.JOB_ID.getValue(reader));
        evt.setTaskIndex((Long)TaskEventField.TASK_INDEX.getValue(reader));
        return evt;
    }

    TaskEvent(int priority, int schedulingClass, TaskEventType type, double resourceRequestForCpuCores, double resourceRequestForRam, double resourceRequestForLocalDiskSpace, String userName, double timestamp) {
        this.priority = priority;
        this.schedulingClass = schedulingClass;
        this.type = type;
        this.resourceRequestForCpuCores = resourceRequestForCpuCores;
        this.resourceRequestForRam = resourceRequestForRam;
        this.resourceRequestForLocalDiskSpace = resourceRequestForLocalDiskSpace;
        this.userName = userName;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getSchedulingClass() {
        return this.schedulingClass;
    }

    public final TaskEventType getType() {
        return this.type;
    }

    public final double getResourceRequestForCpuCores() {
        return this.resourceRequestForCpuCores;
    }

    public final double getResourceRequestForRam() {
        return this.resourceRequestForRam;
    }

    public final double getResourceRequestForLocalDiskSpace() {
        return this.resourceRequestForLocalDiskSpace;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final double getTimestamp() {
        return this.timestamp;
    }

    public final TaskEvent setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public final TaskEvent setSchedulingClass(int schedulingClass) {
        this.schedulingClass = schedulingClass;
        return this;
    }

    public final TaskEvent setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public final TaskEvent setTimestamp(double timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public final TaskEvent setResourceRequestForCpuCores(double resourceRequestForCpuCores) {
        this.resourceRequestForCpuCores = resourceRequestForCpuCores;
        return this;
    }

    public final TaskEvent setResourceRequestForRam(double resourceRequestForRam) {
        this.resourceRequestForRam = resourceRequestForRam;
        return this;
    }

    public final TaskEvent setResourceRequestForLocalDiskSpace(double resourceRequestForLocalDiskSpace) {
        this.resourceRequestForLocalDiskSpace = resourceRequestForLocalDiskSpace;
        return this;
    }

    public static class Builder {
        private int priority;
        private int schedulingClass;
        private TaskEventType type;
        private double resourceRequestForCpuCores;
        private double resourceRequestForRam;
        private double resourceRequestForLocalDiskSpace;
        private String userName;
        private double timestamp;

        Builder() {
        }

        public final Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public final Builder schedulingClass(int schedulingClass) {
            this.schedulingClass = schedulingClass;
            return this;
        }

        public final Builder type(TaskEventType type) {
            this.type = type;
            return this;
        }

        public final Builder resourceRequestForCpuCores(double resourceRequestForCpuCores) {
            this.resourceRequestForCpuCores = resourceRequestForCpuCores;
            return this;
        }

        public final Builder resourceRequestForRam(double resourceRequestForRam) {
            this.resourceRequestForRam = resourceRequestForRam;
            return this;
        }

        public final Builder resourceRequestForLocalDiskSpace(double resourceRequestForLocalDiskSpace) {
            this.resourceRequestForLocalDiskSpace = resourceRequestForLocalDiskSpace;
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TaskEvent build() {
            return new TaskEvent(this.priority, this.schedulingClass, this.type, this.resourceRequestForCpuCores, this.resourceRequestForRam, this.resourceRequestForLocalDiskSpace, this.userName, this.timestamp);
        }

        public String toString() {
            return "TaskEvent.Builder(priority=" + this.priority + ", schedulingClass=" + this.schedulingClass + ", type=" + this.type + ", resourceRequestForCpuCores=" + this.resourceRequestForCpuCores + ", resourceRequestForRam=" + this.resourceRequestForRam + ", resourceRequestForLocalDiskSpace=" + this.resourceRequestForLocalDiskSpace + ", userName=" + this.userName + ", timestamp=" + this.timestamp + ")";
        }
    }
}

