/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudsimplus.traces.google.MachineDataBase;

public final class MachineEvent
extends MachineDataBase {
    private double timestamp;
    private long ram;
    private int cpuCores;

    private MachineEvent(double timestamp, long ram, int cpuCores, long machineId) {
        super(machineId);
        this.timestamp = timestamp;
        this.ram = ram;
        this.cpuCores = cpuCores;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final double getTimestamp() {
        return this.timestamp;
    }

    public final long getRam() {
        return this.ram;
    }

    public final int getCpuCores() {
        return this.cpuCores;
    }

    public final MachineEvent setTimestamp(double timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public final MachineEvent setRam(long ram) {
        this.ram = ram;
        return this;
    }

    public final MachineEvent setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
        return this;
    }

    public static class Builder {
        private double timestamp;
        private long ram;
        private int cpuCores;
        private long machineId;

        Builder() {
        }

        public final Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder ram(long ram) {
            this.ram = ram;
            return this;
        }

        public final Builder cpuCores(int cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public final Builder machineId(long machineId) {
            this.machineId = machineId;
            return this;
        }

        public MachineEvent build() {
            return new MachineEvent(this.timestamp, this.ram, this.cpuCores, this.machineId);
        }

        public String toString() {
            return "MachineEvent.Builder(timestamp=" + this.timestamp + ", ram=" + this.ram + ", cpuCores=" + this.cpuCores + ", machineId=" + this.machineId + ")";
        }
    }
}

