/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.CsvTableColumn;
import org.cloudsimplus.testbeds.ConfidenceInterval;
import org.cloudsimplus.testbeds.Experiment;
import org.cloudsimplus.testbeds.ExperimentRunner;

final class ResultTable<T extends Experiment<T>> {
    private final ExperimentRunner<T> runner;
    private final List<ConfidenceInterval> confidenceIntervals;

    ResultTable(ExperimentRunner<T> runner, List<ConfidenceInterval> confidenceIntervals) {
        this.runner = runner;
        this.confidenceIntervals = confidenceIntervals;
    }

    void buildCsvResultsTable() {
        String cols = this.confidenceIntervals.stream().map(ConfidenceInterval::getMetricName).collect(Collectors.joining("; "));
        System.out.printf("Type of Value;%s%n", cols);
        String format = "%.2f";
        String values = this.confidenceIntervals.stream().map(ci -> CsvTableColumn.alignStringRight("%.2f".formatted(ci.getValue()), ci.getMetricName().length())).collect(Collectors.joining("; "));
        String valueType = this.runner.getSimulationRuns() > 1 ? "CI           " : "Mean         ";
        System.out.printf("%s;%s%n", valueType, values);
        String errorMargins = this.confidenceIntervals.stream().map(ci -> CsvTableColumn.alignStringRight("%.2f".formatted(ci.getErrorMargin()), ci.getMetricName().length())).collect(Collectors.joining("; "));
        System.out.printf("Error Margin ;%s%n", errorMargins);
    }

    void buildLatexMetricsResultTable() {
        if (!this.runner.isLatexTableResultsGeneration()) {
            return;
        }
        if (this.runner.getSimulationRuns() == 1) {
            System.out.println("Latex table with metrics' results is just built when the number of simulation runs is greater than 1.");
            return;
        }
        StringBuilder latex = this.startLatexTable();
        this.confidenceIntervals.forEach(ci -> this.latexRow(latex, (ConfidenceInterval)ci));
        latex.append("  \\end{tabular}\n\\end{table}\n");
        System.out.println();
        System.out.println(latex);
    }

    private StringBuilder startLatexTable() {
        String fmt = "\\begin{table}[!hbt]\n    \\caption{%s}\n    \\label{%s}\n\n    \\begin{tabular}{|p{2.8cm}|p{1.3cm}p{1.3cm}|>{\\raggedleft\\arraybackslash}p{1.2cm}|}\n    \\hline\n    \\textbf{Metric} & \\multicolumn{2}{p{3.0cm}|}{\\textbf{95\\% Confidence Interval}} & \\textbf{*Std. Dev.} \\\\\n    \\hline\n";
        String str = "\\begin{table}[!hbt]\n    \\caption{%s}\n    \\label{%s}\n\n    \\begin{tabular}{|p{2.8cm}|p{1.3cm}p{1.3cm}|>{\\raggedleft\\arraybackslash}p{1.2cm}|}\n    \\hline\n    \\textbf{Metric} & \\multicolumn{2}{p{3.0cm}|}{\\textbf{95\\% Confidence Interval}} & \\textbf{*Std. Dev.} \\\\\n    \\hline\n".formatted(this.runner.getDescription(), this.runner.getResultsTableId());
        return new StringBuilder(str);
    }

    private void latexRow(StringBuilder latex, ConfidenceInterval ci) {
        String COL_SEPARATOR = " & ";
        String errorMargin = ci.isComputed() ? " & $\\pm$ %.2f".formatted(ci.getErrorMargin()) : " & ";
        String escapedMetricName = StringUtils.replace((String)ci.getMetricName(), (String)"%", (String)"\\%");
        latex.append(escapedMetricName).append(" & ").append("%.2f".formatted(ci.getValue())).append(errorMargin).append(" & ").append("%.2f".formatted(ci.getStdDev())).append("\\\\ \\hline\n");
    }
}

