/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.slametrics;

import lombok.NonNull;

public final class SlaMetricDimension {
    private static final String MAX_VALUE_NAME = "maxValue";
    private static final String MIN_VALUE_NAME = "minValue";
    @NonNull
    private String name = "";
    @NonNull
    private String unit = "";
    private double value;

    public SlaMetricDimension() {
        this(0.0);
    }

    public SlaMetricDimension(double value) {
        this.setValue(value);
    }

    public double getValue() {
        return this.isPercent() ? this.value / 100.0 : this.value;
    }

    public boolean isMaxValue() {
        return this.name.trim().equals(MAX_VALUE_NAME);
    }

    public boolean isMinValue() {
        return this.name.trim().equals(MIN_VALUE_NAME);
    }

    public boolean isPercent() {
        return "Percent".equalsIgnoreCase(this.unit);
    }

    public String toString() {
        String valStr = this.value == Double.MAX_VALUE ? "Double.MAX_VALUE" : "%.4f".formatted(this.value);
        return "Dimension{name = %s, value = %s}".formatted(this.name, valStr);
    }

    @NonNull
    public final String getName() {
        return this.name;
    }

    @NonNull
    public final String getUnit() {
        return this.unit;
    }

    public final SlaMetricDimension setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public final SlaMetricDimension setUnit(@NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.unit = unit;
        return this;
    }

    public final SlaMetricDimension setValue(double value) {
        this.value = value;
        return this;
    }
}

